/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.kink_lang.kink.BinVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;
import org.kink_lang.kink.internal.num.NumOperations;

public class BinHelper {
    private final Vm vm;
    SharedVars sharedVars;
    int maxSize = Integer.MAX_VALUE;

    BinHelper(Vm vm) {
        this.vm = vm;
    }

    public BinVal of(byte[] bytes) {
        return new BinVal(this.vm, Arrays.copyOf(bytes, bytes.length));
    }

    public BinVal of(byte[] bytes, int from, int to) {
        byte[] copy = Arrays.copyOfRange(bytes, from, to);
        return new BinVal(this.vm, copy);
    }

    int getMaxSize() {
        return this.maxSize;
    }

    void init() {
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addMethod(vars, "Bin", "empty?", "", 0, (c, desc, bin) -> this.vm.bool.of(bin.size() == 0));
        this.addMethod(vars, "Bin", "size", "", 0, (c, desc, bin) -> this.vm.num.of(bin.size()));
        this.addMethod(vars, "Bin", "get", "(Ind)", 1, this::getMethod);
        this.addMethod(vars, "Bin", "slice", "(From_pos To_pos)", 2, this::sliceMethod);
        this.addTakeDropMethod(vars, "take_front", 0, 0, 1, 0);
        this.addTakeDropMethod(vars, "take_back", -1, 1, 0, 1);
        this.addTakeDropMethod(vars, "drop_front", 1, 0, 0, 1);
        this.addTakeDropMethod(vars, "drop_back", 0, 0, -1, 1);
        this.addBinaryOp(vars, "Bin", "op_add", "Arg_bin", this::opAddMethod);
        this.addMethod(vars, "Bin", "op_mul", "(Count)", 1, this::opMulMethod);
        this.addBinaryOp(vars, "Bin", "op_lt", "Arg_bin", (c, desc, x, y) -> this.vm.bool.of(x.compareTo((BinVal)y) < 0));
        this.addBinaryOp(vars, "Bin", "op_eq", "Arg_bin", (c, desc, x, y) -> this.vm.bool.of(x.equals(y)));
        this.addMethod(vars, "Bin", "repr", "", 0, this::reprMethod);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult getMethod(CallContext c, String desc, BinVal bin) {
        Val val = c.arg(0);
        if (!(val instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be a num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        NumVal indVal = (NumVal)val;
        int ind = NumOperations.getElemIndex(indVal.bigDecimal(), bin.size());
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(Integer.toString(bin.size()))), this.vm.graph.repr(indVal)));
        }
        return this.vm.num.of(Byte.toUnsignedInt(bin.get(ind)));
    }

    private HostResult sliceMethod(CallContext c, String desc, BinVal bin) {
        Val val = c.arg(0);
        if (!(val instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: From_pos must be an int num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        NumVal fromVal = (NumVal)val;
        BigDecimal fromDec = fromVal.bigDecimal();
        Val val2 = c.arg(1);
        if (!(val2 instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: To_pos must be an int num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        NumVal toVal = (NumVal)val2;
        BigDecimal toDec = toVal.bigDecimal();
        if (!NumOperations.isRangePair(fromDec, toDec, bin.size())) {
            return c.call(this.vm.graph.raiseFormat("{}: required range in [0, {}] but got [{}, {}]", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(this.vm.num.of(bin.size())), this.vm.graph.repr(fromVal), this.vm.graph.repr(toVal)));
        }
        int from = fromDec.intValueExact();
        int to = toDec.intValueExact();
        return bin.slice(from, to);
    }

    private void addTakeDropMethod(Map<Integer, Val> vars, String methodName, int fromNumCoef, int fromSizeCoef, int toNumCoef, int toSizeCoef) {
        this.addMethod(vars, "Bin", methodName, "(N)", 1, (c, desc, bin) -> {
            Val patt5618$temp = c.arg(0);
            if (!(patt5618$temp instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: N must be an int num, but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.repr(c.arg(0))));
            }
            NumVal numVal = (NumVal)patt5618$temp;
            BigDecimal numDec = numVal.bigDecimal();
            int size = bin.size();
            int num = NumOperations.getPosIndex(numDec, size);
            if (num < 0) {
                return c.call(this.vm.graph.raiseFormat("{}: N must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(numVal)));
            }
            int from = fromNumCoef * num + fromSizeCoef * size;
            int to = toNumCoef * num + toSizeCoef * size;
            return bin.slice(from, to);
        });
    }

    private HostResult opAddMethod(CallContext c, String desc, BinVal x, BinVal y) {
        long resultSize = (long)x.size() + (long)y.size();
        if (resultSize > (long)this.vm.bin.getMaxSize()) {
            return c.call(this.vm.graph.raiseFormat("{}: too long result: size {} + size {} is {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(x.size())), this.vm.graph.of(this.vm.num.of(y.size())), this.vm.graph.of(this.vm.num.of(resultSize))));
        }
        return x.concat(y);
    }

    private HostResult opMulMethod(CallContext c, String desc, BinVal bin) {
        BigInteger count = NumOperations.getExactBigInteger(c.arg(0));
        if (count == null || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Count must be int num >=0, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        if (bin.size() == 0) {
            return bin;
        }
        BigInteger resultSize = count.multiply(BigInteger.valueOf(bin.size()));
        if (resultSize.compareTo(BigInteger.valueOf(this.vm.bin.getMaxSize())) > 0) {
            return c.call(this.vm.graph.raiseFormat("{}: too long result: size {} * Count {} is {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(bin.size())), this.vm.graph.repr(c.arg(0)), this.vm.graph.of(this.vm.num.of(resultSize))));
        }
        int countInt = count.intValueExact();
        byte[] bytes = bin.bytes();
        byte[] result = new byte[countInt * bin.size()];
        for (int i = 0; i < countInt; ++i) {
            System.arraycopy(bytes, 0, result, i * bytes.length, bytes.length);
        }
        return this.vm.bin.of(result);
    }

    private HostResult reprMethod(CallContext c, String desc, BinVal bin) {
        StringJoiner sj = new StringJoiner(" ", "(", ")");
        sj.add("bin");
        for (byte b : bin.bytes()) {
            String s = Integer.toString(Byte.toUnsignedInt(b), 16);
            sj.add((s.length() == 1 ? "0x0" : "0x") + s);
        }
        return this.vm.str.of(sj.toString());
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String methodName, String argsDesc, int arity, ThrowingFunction3<CallContext, String, BinVal, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s%s", recvDesc, methodName, argsDesc);
        int handle = this.vm.sym.handleFor(methodName);
        FunVal fun = this.vm.fun.make(desc).take(arity).action(c -> {
            Val patt9666$temp = c.recv();
            if (!(patt9666$temp instanceof BinVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be bin, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(c.recv())));
            }
            BinVal recv = (BinVal)patt9666$temp;
            return (HostResult)action.apply(c, desc, recv);
        });
        vars.put(handle, fun);
    }

    private void addBinaryOp(Map<Integer, Val> vars, String recvDesc, String methodName, String argDesc, ThrowingFunction4<CallContext, String, BinVal, BinVal, HostResult> action) {
        String argsDesc = "(" + argDesc + ")";
        this.addMethod(vars, recvDesc, methodName, argsDesc, 1, (c, desc, recv) -> {
            Val patt10518$temp = c.arg(0);
            if (!(patt10518$temp instanceof BinVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be bin, but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.repr(c.arg(0))));
            }
            BinVal arg = (BinVal)patt10518$temp;
            return (HostResult)action.apply((CallContext)c, (String)desc, (BinVal)recv, arg);
        });
    }
}

