/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunBuilder;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.num.NumOperations;

public class StrHelper {
    private final Vm vm;
    private int formatHandle;
    private int argHandle;
    int maxLength = Integer.MAX_VALUE;
    SharedVars sharedVars;
    private static final Map<Character, String> CHAR_TO_REPR;

    StrHelper(Vm vm) {
        this.vm = vm;
    }

    public StrVal of(String string) {
        return new StrVal(this.vm, string);
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void init() {
        this.formatHandle = this.vm.sym.handleFor("format");
        this.argHandle = this.vm.sym.handleFor("arg");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addMethod(vars, "Str1", "op_add", "(Str2)", 1, this::opAddMethod);
        this.addMethod(vars, "Str", "runes", "", 0, this::runesMethod);
        this.addMethod(vars, "Str", "empty?", "", 0, (CallContext c, StrVal s, String d) -> this.vm.bool.of(s.string().isEmpty()));
        this.addMethod(vars, "Str", "size", "", 0, (CallContext c, StrVal s, String d) -> this.vm.num.of(s.runeCount()));
        this.addMethod(vars, "Str", "get", "(Rune_index)", 1, this::getMethod);
        this.addMethod(vars, "Str", "slice", "(From_pos To_pos)", 2, this::sliceMethod);
        this.addTakeDropMethod(vars, "take_front", 0, 0, 1, 0);
        this.addTakeDropMethod(vars, "take_back", -1, 1, 0, 1);
        this.addTakeDropMethod(vars, "drop_front", 1, 0, 0, 1);
        this.addTakeDropMethod(vars, "drop_back", 0, 0, -1, 1);
        this.addMethod(vars, "Str", "search_slice", "(Min_ind Slice)", 2, this::searchSliceMethod);
        this.addBinaryOp(vars, "Str", "have_prefix?", "Prefix", (c, text, pat) -> this.vm.bool.of(text.string().startsWith(pat.string())));
        this.addBinaryOp(vars, "Str", "have_suffix?", "Suffix", (c, text, pat) -> this.vm.bool.of(text.string().endsWith(pat.string())));
        this.addBinaryOp(vars, "Str", "have_slice?", "Slice", (c, text, pat) -> this.vm.bool.of(text.string().contains(pat.string())));
        this.addMethod(vars, "Str", "trim", "", 0, this::trimMethod);
        this.addMethod(vars, "Str", "trim_front", "", 0, this::trimFrontMethod);
        this.addMethod(vars, "Str", "trim_back", "", 0, this::trimBackMethod);
        this.addMethod(vars, "Str", "ascii_upcase", "", 0, this::asciiUpcaseMethod);
        this.addMethod(vars, "Str", "ascii_downcase", "", 0, this::asciiDowncaseMethod);
        this.addMethod(vars, "Str", "format", "(,,,)", b -> b, this::formatMethod);
        this.addMethod(vars, "Str", "op_mul", "(Count)", 1, this::opMulMethod);
        this.addBinaryOp(vars, "Str1", "op_lt", "Str2", (c, x, y) -> this.vm.bool.of(this.lessThanByRunes(x.string(), y.string())));
        this.addBinaryOp(vars, "Str1", "op_eq", "Str2", (c, x, y) -> this.vm.bool.of(x.string().equals(y.string())));
        this.addMethod(vars, "Str", "repr", "", 0, this::reprMethod);
        this.addMethod(vars, "Str", "show", "(...[$config])", b -> b.takeMinMax(0, 1), (CallContext c, StrVal s, String d) -> s);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult opAddMethod(CallContext c, StrVal str, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: required str as Str2, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal argStr = (StrVal)val;
        if ((long)str.length() + (long)argStr.length() > (long)this.vm.str.getMaxLength()) {
            return c.raise(desc + ": too long result");
        }
        return str.concat(argStr);
    }

    private HostResult runesMethod(CallContext c, StrVal strVal, String desc) {
        List<NumVal> runes = strVal.string().codePoints().mapToObj(rune -> this.vm.num.of(rune)).toList();
        return this.vm.vec.of(runes);
    }

    private HostResult getMethod(CallContext c, StrVal strVal, String desc) {
        String str = strVal.string();
        Val runeIndexVal = c.arg(0);
        int runeIndex = NumOperations.getElemIndex(runeIndexVal, strVal.runeCount());
        if (runeIndex < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Rune_index must be int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(strVal.runeCount())), this.vm.graph.repr(runeIndexVal)));
        }
        int index = strVal.runePosToCharPos(runeIndex);
        int rune = str.codePointAt(index);
        return this.vm.num.of(rune);
    }

    private HostResult sliceMethod(CallContext c, StrVal strVal, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: From_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        NumVal fromNum = (NumVal)val;
        BigDecimal fromDec = fromNum.bigDecimal();
        Val val2 = c.arg(1);
        if (!(val2 instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: To_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        NumVal toNum = (NumVal)val2;
        BigDecimal toDec = toNum.bigDecimal();
        String str = strVal.string();
        if (!NumOperations.isRangePair(fromDec, toDec, strVal.runeCount())) {
            return c.call(this.vm.graph.raiseFormat("{}: required index pair in [0, {}], but got {} and {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(strVal.runeCount())), this.vm.graph.repr(fromNum), this.vm.graph.repr(toNum)));
        }
        int fromRuneInd = fromDec.intValueExact();
        int toRuneInd = toDec.intValueExact();
        int fromInd = strVal.runePosToCharPos(fromRuneInd);
        int toInd = strVal.runePosToCharPos(toRuneInd);
        return this.vm.str.of(str.substring(fromInd, toInd));
    }

    private void addTakeDropMethod(Map<Integer, Val> vars, String sym, int fromNumCoef, int fromSizeCoef, int toNumCoef, int toSizeCoef) {
        this.addMethod(vars, "Str", sym, "(N)", 1, (CallContext c, StrVal strVal, String desc) -> {
            String str = strVal.string();
            int num = NumOperations.getPosIndex(c.arg(0), strVal.runeCount());
            if (num < 0) {
                return c.call(this.vm.graph.raiseFormat("{}: N must be int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.num.of(strVal.runeCount())), this.vm.graph.repr(c.arg(0))));
            }
            int fromRuneInd = fromNumCoef * num + fromSizeCoef * strVal.runeCount();
            int toRuneInd = toNumCoef * num + toSizeCoef * strVal.runeCount();
            int fromCharInd = strVal.runePosToCharPos(fromRuneInd);
            int toCharInd = strVal.runePosToCharPos(toRuneInd);
            return this.vm.str.of(str.substring(fromCharInd, toCharInd));
        });
    }

    private HostResult searchSliceMethod(CallContext c, StrVal strVal, String desc) {
        String str = strVal.string();
        int minRuneInd = NumOperations.getPosIndex(c.arg(0), strVal.runeCount());
        if (minRuneInd < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Min_ind must be int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(strVal.runeCount())), this.vm.graph.repr(c.arg(0))));
        }
        Val val = c.arg(1);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Slice must be str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        StrVal slice = (StrVal)val;
        int minCharInd = strVal.runePosToCharPos(minRuneInd);
        int charInd = str.indexOf(slice.string(), minCharInd);
        if (charInd < 0) {
            return this.vm.vec.of();
        }
        int runeInd = str.codePointCount(0, charInd);
        return this.vm.vec.of((Val)this.vm.num.of(runeInd));
    }

    private HostResult trimMethod(CallContext c, StrVal strVal, String desc) {
        String s = strVal.string();
        int to = StrHelper.startOfTrailingSpaceLikeCharsInd(s);
        int from = StrHelper.endOfLeadingSpaceLikeCharsInd(s, to);
        return this.vm.str.of(s.substring(from, to));
    }

    private HostResult trimFrontMethod(CallContext c, StrVal strVal, String desc) {
        String s = strVal.string();
        int from = StrHelper.endOfLeadingSpaceLikeCharsInd(s, s.length());
        return this.vm.str.of(s.substring(from));
    }

    private HostResult trimBackMethod(CallContext c, StrVal strVal, String desc) {
        String s = strVal.string();
        int to = StrHelper.startOfTrailingSpaceLikeCharsInd(s);
        return this.vm.str.of(s.substring(0, to));
    }

    private static int endOfLeadingSpaceLikeCharsInd(String s, int upperBoundEx) {
        for (int i = 0; i < upperBoundEx; ++i) {
            if (StrHelper.isSpaceLikeChar(s.charAt(i))) continue;
            return i;
        }
        return upperBoundEx;
    }

    private static int startOfTrailingSpaceLikeCharsInd(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (StrHelper.isSpaceLikeChar(s.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }

    private static boolean isSpaceLikeChar(char ch) {
        return ch <= ' ' || ch == '\u007f';
    }

    private HostResult asciiUpcaseMethod(CallContext c, StrVal strVal, String desc) {
        String src = strVal.string();
        StringBuilder sb = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            char dest = 'a' <= ch && ch <= 'z' ? (char)(ch + -32) : ch;
            sb.append(dest);
        }
        return this.vm.str.of(sb.toString());
    }

    private HostResult asciiDowncaseMethod(CallContext c, StrVal strVal, String desc) {
        String src = strVal.string();
        StringBuilder sb = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            char dest = 'A' <= ch && ch <= 'Z' ? (char)(ch + 32) : ch;
            sb.append(dest);
        }
        return this.vm.str.of(sb.toString());
    }

    private HostResult formatMethod(CallContext c, StrVal template, String desc) {
        if (c.argCount() == 1 && c.arg(0) instanceof FunVal) {
            FunVal config = (FunVal)c.arg(0);
            return c.call("kink/_str/FORMAT", this.formatHandle).args((Val)template, (Val)config);
        }
        List<Val> args = IntStream.range(0, c.argCount()).mapToObj(i -> c.arg(i)).toList();
        FunVal config = this.vm.fun.make().take(1).action(cc -> this.formatMethodConfigAux(cc, cc.arg(0), args));
        return c.call("kink/_str/FORMAT", this.formatHandle).args((Val)template, (Val)config);
    }

    private HostResult formatMethodConfigAux(HostContext c, Val conf, List<Val> args) {
        if (args.isEmpty()) {
            return this.vm.nada;
        }
        return c.call(conf, this.argHandle).args(args.get(0)).on((cc, r) -> this.formatMethodConfigAux(cc, conf, args.subList(1, args.size())));
    }

    private HostResult opMulMethod(CallContext c, StrVal strVal, String desc) {
        String str = strVal.string();
        BigInteger count = NumOperations.getExactBigInteger(c.arg(0));
        if (count == null || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("Str.op_mul(Count): required int num >=0 for Count, but got {}", this.vm.graph.repr(c.arg(0))));
        }
        if (str.isEmpty()) {
            return this.vm.str.of("");
        }
        BigInteger resultLen = count.multiply(BigInteger.valueOf(str.length()));
        if (resultLen.compareTo(BigInteger.valueOf(this.vm.str.getMaxLength())) > 0) {
            return c.raise("Str.op_mul(Count): too long result");
        }
        StringBuilder sb = new StringBuilder();
        int countInt = count.intValueExact();
        for (int i = 0; i < countInt; ++i) {
            sb.append(str);
        }
        return this.vm.str.of(sb.toString());
    }

    private boolean lessThanByRunes(String x, String y) {
        int xi = 0;
        int yi = 0;
        while (yi < y.length()) {
            int yrune;
            if (xi >= x.length()) {
                return true;
            }
            int xrune = x.codePointAt(xi);
            if (xrune < (yrune = y.codePointAt(yi))) {
                return true;
            }
            if (xrune > yrune) {
                return false;
            }
            xi = x.offsetByCodePoints(xi, 1);
            yi = y.offsetByCodePoints(yi, 1);
        }
        return false;
    }

    private StrVal reprMethod(CallContext c, StrVal strVal, String desc) {
        return this.reprMethodImpl(strVal.string());
    }

    StrVal reprMethodImpl(String str) {
        StringBuilder sb = new StringBuilder("\"");
        for (char ch : str.toCharArray()) {
            String repr = CHAR_TO_REPR.getOrDefault(Character.valueOf(ch), Character.toString(ch));
            sb.append(repr);
        }
        sb.append('\"');
        return this.vm.str.of(sb.toString());
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argsDesc, int arity, ThrowingFunction3<CallContext, StrVal, String, HostResult> action) {
        this.addMethod(vars, recvDesc, sym, argsDesc, b -> b.take(arity), action);
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argsDesc, UnaryOperator<HostFunBuilder> limitArity, ThrowingFunction3<CallContext, StrVal, String, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s%s", recvDesc, sym, argsDesc);
        int handle = this.vm.sym.handleFor(sym);
        FunVal fun = ((HostFunBuilder)limitArity.apply(this.vm.fun.make(desc))).action(c -> {
            Val patt18037$temp = c.recv();
            if (!(patt18037$temp instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(c.recv())));
            }
            StrVal recvStr = (StrVal)patt18037$temp;
            return (HostResult)action.apply(c, recvStr, desc);
        });
        vars.put(handle, fun);
    }

    private void addBinaryOp(Map<Integer, Val> vars, String recvDesc, String sym, String argDesc, ThrowingFunction3<CallContext, StrVal, StrVal, HostResult> action) {
        this.addMethod(vars, recvDesc, sym, "(" + argDesc + ")", 1, (CallContext c, StrVal recv, String desc) -> {
            Val patt18837$temp = c.arg(0);
            if (!(patt18837$temp instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be str, but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.repr(c.arg(0))));
            }
            StrVal argStr = (StrVal)patt18837$temp;
            return (HostResult)action.apply((CallContext)c, (StrVal)recv, argStr);
        });
    }

    static {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('\u0000'), "\\0");
        map.put(Character.valueOf('\u0007'), "\\a");
        map.put(Character.valueOf('\b'), "\\b");
        map.put(Character.valueOf('\t'), "\\t");
        map.put(Character.valueOf('\n'), "\\n");
        map.put(Character.valueOf('\u000b'), "\\v");
        map.put(Character.valueOf('\f'), "\\f");
        map.put(Character.valueOf('\r'), "\\r");
        map.put(Character.valueOf('\u001b'), "\\e");
        map.put(Character.valueOf('\"'), "\\\"");
        map.put(Character.valueOf('\\'), "\\\\");
        map.put(Character.valueOf('\u007f'), "\\x{00007f}");
        for (char ch = '\u0001'; ch <= '\u001f'; ch = (char)(ch + '\u0001')) {
            map.putIfAbsent(Character.valueOf(ch), String.format(Locale.ROOT, "\\x{%06x}", (int)ch));
        }
        CHAR_TO_REPR = Collections.unmodifiableMap(map);
    }
}

