/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.callstack;

import java.util.List;
import java.util.stream.LongStream;
import org.kink_lang.kink.internal.callstack.Cse;
import org.kink_lang.kink.internal.callstack.Lnums;
import org.kink_lang.kink.internal.callstack.TailTraceRingBuffer;
import org.kink_lang.kink.internal.contract.Preconds;

public record CallStackSlice(Cse[] callStackElements, TailTraceRingBuffer[] tailTraceRingBuffers, long[] lnums) {
    public CallStackSlice {
        Preconds.checkArg(callStackElements.length == tailTraceRingBuffers.length, "#callStackElements must be equal to #tailTraceRingBuffers");
        Preconds.checkArg(callStackElements.length == lnums.length, "#callStackElements must be equal to #lnums");
    }

    public int size() {
        return this.callStackElements().length;
    }

    public int dataStackUsage() {
        int sum = 0;
        for (long lnum : this.lnums) {
            sum += Lnums.getDataStackUsage(lnum);
        }
        return sum;
    }

    private List<Object> properties() {
        return List.of(List.of(this.callStackElements), List.of(this.tailTraceRingBuffers), LongStream.of(this.lnums()).mapToObj(n -> n).toList());
    }

    @Override
    public int hashCode() {
        return this.properties().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof CallStackSlice)) return false;
        CallStackSlice argSlice = (CallStackSlice)arg;
        if (!this.properties().equals(argSlice.properties())) return false;
        return true;
    }
}

