/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.ast;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.function.Function3;
import org.kink_lang.kink.internal.program.ast.CompileException;
import org.kink_lang.kink.internal.program.ast.ParseRun;
import org.kink_lang.kink.internal.program.ast.SeqExpr;
import org.kink_lang.kink.internal.program.lex.EotToken;
import org.kink_lang.kink.internal.program.lex.ErrorToken;
import org.kink_lang.kink.internal.program.lex.Token;

public class Parser {
    private final Function<List<Token>, ParseRun> parseRunFactory;

    public Parser(Locale locale) {
        this(locale, tokens -> new ParseRun(locale, (List<Token>)tokens));
    }

    Parser(Locale locale, Function<List<Token>, ParseRun> parseRunFactory) {
        this.parseRunFactory = parseRunFactory;
    }

    public <T> T parse(List<Token> tokens, Function<? super SeqExpr, ? extends T> onSucc, Function3<? super String, ? super Integer, ? super Integer, ? extends T> onError) {
        Preconds.checkArg(!tokens.isEmpty(), "tokens must not be empty");
        Token last = tokens.get(tokens.size() - 1);
        Preconds.checkArg(last instanceof EotToken || last instanceof ErrorToken, "last token must be EotToken or ErrorToken");
        ParseRun parseRun = this.parseRunFactory.apply(tokens);
        try {
            SeqExpr seq = parseRun.run();
            return onSucc.apply(seq);
        }
        catch (CompileException ce) {
            return onError.apply(ce.getMessage(), ce.getStartPos(), ce.getEndPos());
        }
    }
}

