/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.CondThenPair;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.RecvArgsSearcher;

public class BranchInliner
extends BaseOptimizer {
    @Override
    public Itree visit(SymcallItree scall) {
        if (!scall.isLocalCallOf("branch")) {
            return scall;
        }
        List<ItreeElem> argElems = scall.args();
        if (argElems.size() % 2 != 0) {
            return scall;
        }
        if (!argElems.stream().allMatch(ItreeElem::isSingle)) {
            return scall;
        }
        List<Itree> args = argElems.stream().map(ItreeElem::expr).toList();
        if (!args.stream().allMatch(arg -> arg instanceof FastFunItree)) {
            return scall;
        }
        List<FastFunItree> funs = args.stream().map(itree -> (FastFunItree)itree).toList();
        ArrayList<CondThenPair> condThenPairs = new ArrayList<CondThenPair>();
        for (int i = 0; i < funs.size(); i += 2) {
            FastFunItree condFun = funs.get(i);
            FastFunItree bodyFun = funs.get(i + 1);
            if (RecvArgsSearcher.containsRecvOrArgs(condFun.body()) || RecvArgsSearcher.containsRecvOrArgs(bodyFun.body())) {
                return scall;
            }
            condThenPairs.add(new CondThenPair(condFun, bodyFun));
        }
        return new BranchItree(condThenPairs, scall.pos());
    }
}

