/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.kink_lang.kink.HostResultCore;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StackMachine;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.control.Control;
import org.kink_lang.kink.internal.ovis.OwnVarIndexes;

public class Val
extends HostResultCore
implements HostResult {
    public final Vm vm;
    @Nullable
    private final SharedVars sharedVars;
    private OwnVarIndexes ovis;
    private static final VarHandle OVIS_VH = Control.runWrappingThrowable(() -> MethodHandles.lookup().findVarHandle(Val.class, "ovis", OwnVarIndexes.class));
    private Val v0;
    private Val v1;
    private Val v2;
    private Val v3;
    private Val v4;
    private Val v5;
    private Val[] moreVars;
    static final Val[] EMPTY_VS = new Val[0];
    private static final VarHandle MOREVARS_VH = Control.runWrappingThrowable(() -> MethodHandles.lookup().findVarHandle(Val.class, "moreVars", Val[].class));
    private static final AtomicReference<BigDecimal> UNIQUE_PRODUCER = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
    private static final AtomicReferenceFieldUpdater<Val, BigDecimal> IDENTITY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Val.class, BigDecimal.class, "identity");
    private volatile BigDecimal identity;

    protected Val(Vm vm) {
        this(vm, vm.sharedVars.minimal, vm.emptyOvis, null, null, null, null, null, null, EMPTY_VS);
    }

    protected Val(Vm vm, SharedVars sharedVars) {
        this(vm, sharedVars, vm.emptyOvis, null, null, null, null, null, null, EMPTY_VS);
    }

    Val(Vm vm, SharedVars sharedVars, OwnVarIndexes ovis, Val v0, Val v1, Val v2, Val v3, Val v4, Val v5, Val[] moreVars) {
        this.vm = vm;
        this.sharedVars = sharedVars;
        this.ovis = ovis;
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.v4 = v4;
        this.v5 = v5;
        this.moreVars = moreVars;
    }

    Val(Val orig) {
        this(orig.vm, orig.sharedVars, orig.ovis, orig.v0, orig.v1, orig.v2, orig.v3, orig.v4, orig.v5, Val.copyOf(orig.moreVars));
    }

    private static Val[] copyOf(Val[] moreVars) {
        if (moreVars.length == 0) {
            return moreVars;
        }
        Val[] newMvs = new Val[moreVars.length];
        System.arraycopy(moreVars, 0, newMvs, 0, moreVars.length);
        return newMvs;
    }

    @Override
    final void doTransition(StackMachine stackMachine) {
        stackMachine.getDataStack().removeFromOffset(0);
        stackMachine.transitionToResult(this);
    }

    @Override
    public final HostResultCore makeHostResultCore() {
        return this;
    }

    final BigDecimal identityDecimal() {
        if (this.identity == null) {
            BigDecimal newNum = UNIQUE_PRODUCER.updateAndGet(n -> n.add(BigDecimal.ONE));
            IDENTITY_UPDATER.compareAndSet(this, null, newNum);
        }
        return this.identity;
    }

    public final BigInteger identity() {
        return this.identityDecimal().toBigInteger();
    }

    public final void setVar(int symHandle, Val val) {
        int index = this.addAndGetIndex(symHandle);
        this.setAtIndex(index, val);
    }

    @Nullable
    public final Val getVar(int symHandle) {
        Val ownVar = this.getOwnVar(symHandle);
        return ownVar != null ? ownVar : this.getShared(symHandle);
    }

    public final boolean hasVar(int symHandle) {
        return this.getVar(symHandle) != null;
    }

    public final Set<Integer> getVarSymHandleSet() {
        HashSet<Integer> symHandles = new HashSet<Integer>(this.sharedVars().symHandleSet());
        symHandles.addAll(this.getOwnVarSymHandleSet());
        return Collections.unmodifiableSet(symHandles);
    }

    SharedVars sharedVars() {
        return this.sharedVars;
    }

    private Val getShared(int symHandle) {
        return this.sharedVars().get(symHandle);
    }

    final int addAndGetIndex(int symHandle) {
        OwnVarIndexes origOvis;
        int index;
        while ((index = (origOvis = this.ovis).getIndex(symHandle)) < 0) {
            OwnVarIndexes newOvis = origOvis.with(symHandle);
            OVIS_VH.compareAndSet(this, origOvis, newOvis);
        }
        return index;
    }

    final void setOvis(OwnVarIndexes ovis) {
        OVIS_VH.set(this, ovis);
    }

    final OwnVarIndexes getOvis() {
        return this.ovis;
    }

    final boolean noOwnVar() {
        return this.ovis.isEmpty();
    }

    @Nullable
    final Val getOwnVar(int symHandle) {
        int index = this.ovis.getIndex(symHandle);
        return index >= 0 ? this.getOwnAtIndex(index) : null;
    }

    final Set<Integer> getOwnVarSymHandleSet() {
        List<Integer> symHandles = this.ovis.getSymHandles();
        return IntStream.range(0, symHandles.size()).filter(i -> this.getOwnAtIndex(i) != null).mapToObj(symHandles::get).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    final Val getOwnAtIndex(int index) {
        return switch (index) {
            case 0 -> this.v0;
            case 1 -> this.v1;
            case 2 -> this.v2;
            case 3 -> this.v3;
            case 4 -> this.v4;
            case 5 -> this.v5;
            default -> this.getMv(index);
        };
    }

    @Nullable
    private Val getMv(int varInd) {
        Val[] moreVars;
        int mvsInd = Val.toMvsInd(varInd);
        return mvsInd < (moreVars = this.moreVars).length ? moreVars[mvsInd] : null;
    }

    final void setAtIndex(int index, Val val) {
        switch (index) {
            case 0: {
                this.setV0(val);
                break;
            }
            case 1: {
                this.setV1(val);
                break;
            }
            case 2: {
                this.setV2(val);
                break;
            }
            case 3: {
                this.setV3(val);
                break;
            }
            case 4: {
                this.setV4(val);
                break;
            }
            case 5: {
                this.setV5(val);
                break;
            }
            default: {
                this.setMv(index, val);
            }
        }
    }

    private static int toMvsInd(int index) {
        return index - 6;
    }

    final void setV0(Val val) {
        this.v0 = val;
    }

    final void setV1(Val val) {
        this.v1 = val;
    }

    final void setV2(Val val) {
        this.v2 = val;
    }

    final void setV3(Val val) {
        this.v3 = val;
    }

    final void setV4(Val val) {
        this.v4 = val;
    }

    final void setV5(Val val) {
        this.v5 = val;
    }

    final void setMv(int varInd, Val val) {
        Val[] newMvs;
        Val[] origMvs;
        int mvsInd = Val.toMvsInd(varInd);
        while (!MOREVARS_VH.weakCompareAndSet(this, origMvs = MOREVARS_VH.getAcquire(this), newMvs = this.makeMoreVars(origMvs, mvsInd, val))) {
        }
    }

    Val[] makeMoreVars(Val[] origMvs, int mvsInd, Val val) {
        Val[] newMvs = new Val[Math.max(origMvs.length, mvsInd + 1)];
        System.arraycopy(origMvs, 0, newMvs, 0, origMvs.length);
        newMvs[mvsInd] = val;
        return newMvs;
    }

    @Nullable
    final Val getPredictV0(int symHandle, OwnVarIndexes predictedOvis) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.v0;
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictV1(int symHandle, OwnVarIndexes predictedOvis) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.v1;
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictV2(int symHandle, OwnVarIndexes predictedOvis) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.v2;
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictV3(int symHandle, OwnVarIndexes predictedOvis) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.v3;
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictV4(int symHandle, OwnVarIndexes predictedOvis) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.v4;
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictV5(int symHandle, OwnVarIndexes predictedOvis) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.v5;
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictMv(int symHandle, OwnVarIndexes predictedOvis, int varInd) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        Val own = this.getMv(varInd);
        return own != null ? own : this.getShared(symHandle);
    }

    @Nullable
    final Val getPredictShared(int symHandle, OwnVarIndexes predictedOvis, long svUniqueId, int svInd) {
        if (this.ovis != predictedOvis) {
            return this.getVar(symHandle);
        }
        SharedVars sv = this.sharedVars();
        return sv.getUniqueId() == svUniqueId ? sv.getAtIndex(svInd) : sv.get(symHandle);
    }

    final void setPredictV0(int symHandle, Val val, OwnVarIndexes predictedOvis) {
        if (this.ovis == predictedOvis) {
            this.setV0(val);
        } else {
            this.setVar(symHandle, val);
        }
    }

    final void setPredictV1(int symHandle, Val val, OwnVarIndexes predictedOvis) {
        if (this.ovis == predictedOvis) {
            this.setV1(val);
        } else {
            this.setVar(symHandle, val);
        }
    }

    final void setPredictV2(int symHandle, Val val, OwnVarIndexes predictedOvis) {
        if (this.ovis == predictedOvis) {
            this.setV2(val);
        } else {
            this.setVar(symHandle, val);
        }
    }

    final void setPredictV3(int symHandle, Val val, OwnVarIndexes predictedOvis) {
        if (this.ovis == predictedOvis) {
            this.setV3(val);
        } else {
            this.setVar(symHandle, val);
        }
    }

    final void setPredictV4(int symHandle, Val val, OwnVarIndexes predictedOvis) {
        if (this.ovis == predictedOvis) {
            this.setV4(val);
        } else {
            this.setVar(symHandle, val);
        }
    }

    final void setPredictV5(int symHandle, Val val, OwnVarIndexes predictedOvis) {
        if (this.ovis == predictedOvis) {
            this.setV5(val);
        } else {
            this.setVar(symHandle, val);
        }
    }

    final void setPredictMv(int symHandle, Val val, OwnVarIndexes predictedOvis, int varInd) {
        if (this.ovis == predictedOvis) {
            this.setMv(varInd, val);
        } else {
            this.setVar(symHandle, val);
        }
    }
}

