/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.random;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.kink_lang.kink.BinVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.mod.random.RandomNumbers;

public class RngVal<T extends Random>
extends Val {
    private final T random;
    private final String typeTag;

    RngVal(Vm vm, SharedVars sharedVars, T random, String typeTag) {
        super(vm, sharedVars);
        this.random = random;
        this.typeTag = typeTag;
    }

    public static RngVal<Random> of(Vm vm, Random random, String typeTag) {
        RngHelper helper = RngHelper.of(vm);
        return new RngVal<Random>(vm, helper.sharedVars, random, typeTag);
    }

    T getRandom() {
        return this.random;
    }

    static class RngHelper {
        private final Vm vm;
        final Map<Integer, Val> varMap;
        final SharedVars sharedVars;

        private RngHelper(Vm vm) {
            this.vm = vm;
            this.varMap = this.makeVarMap();
            this.sharedVars = vm.sharedVars.of(this.varMap);
        }

        static RngHelper of(Vm vm) {
            return vm.component.getOrRegister(RngHelper.class, RngHelper::new);
        }

        private Map<Integer, Val> makeVarMap() {
            HashMap<Integer, FunVal> map = new HashMap<Integer, FunVal>();
            map.put(this.vm.sym.handleFor("gen_int"), this.vm.fun.make("Rng.gen_int(Upper_bound)").take(1).action(this::genIntMethod));
            map.put(this.vm.sym.handleFor("gen_bin"), this.vm.fun.make("Rng.gen_bin(Size)").take(1).action(this::genBinMethod));
            map.put(this.vm.sym.handleFor("gen_bool"), this.vm.fun.make("Rng.gen_bool").take(0).action(this::genBoolMethod));
            map.put(this.vm.sym.handleFor("repr"), this.vm.fun.make("Rng.repr").take(0).action(this::reprMethod));
            return Collections.unmodifiableMap(map);
        }

        private HostResult genIntMethod(CallContext c) {
            Val upperBound;
            String desc = "Rng.gen_int(Upper_bound)";
            Val recv = c.recv();
            if (!(recv instanceof RngVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: Rng must be an rng val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(recv)));
            }
            RngVal rngVal = (RngVal)recv;
            Object random = rngVal.getRandom();
            NumVal num = RandomNumbers.produceIntNum(this.vm, random, upperBound = c.arg(0));
            return num != null ? num : c.call(this.vm.graph.raiseFormat("{}: Upper_bound must be a positive int num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(upperBound)));
        }

        private HostResult genBinMethod(CallContext c) {
            Val size;
            String desc = "Rng.gen_bin(Size)";
            Val recv = c.recv();
            if (!(recv instanceof RngVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: Rng must be an rng val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(recv)));
            }
            RngVal rngVal = (RngVal)recv;
            Object random = rngVal.getRandom();
            BinVal bin = RandomNumbers.produceBin(this.vm, random, size = c.arg(0));
            return bin != null ? bin : c.call(this.vm.graph.raiseFormat("{}: Size must be an int num in [0, 0x7fff_ffff], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(size)));
        }

        private HostResult genBoolMethod(CallContext c) {
            Val recv = c.recv();
            if (!(recv instanceof RngVal)) {
                return c.call(this.vm.graph.raiseFormat("Rng.gen_bool: Rng must be an rng val, but got {}", this.vm.graph.repr(recv)));
            }
            RngVal rngVal = (RngVal)recv;
            Object random = rngVal.getRandom();
            return this.vm.bool.of(((Random)random).nextBoolean());
        }

        private HostResult reprMethod(CallContext c) {
            Val recv = c.recv();
            if (!(recv instanceof RngVal)) {
                return c.call(this.vm.graph.raiseFormat("Rng.repr: Rng must be an rng val, but got {}", this.vm.graph.repr(recv)));
            }
            RngVal rngVal = (RngVal)recv;
            return this.vm.str.of(String.format(Locale.ROOT, "(%s val_id=%d)", rngVal.typeTag, rngVal.identity()));
        }
    }
}

