/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itree;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.program.itree.ArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.BiArithmeticItree;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.CondThenPair;
import org.kink_lang.kink.internal.program.itree.DerefItree;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.GenericVar;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LetRecItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.McallItree;
import org.kink_lang.kink.internal.program.itree.NestedArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.NestedParam;
import org.kink_lang.kink.internal.program.itree.NestedVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.OptRestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.OptVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.RestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;
import org.kink_lang.kink.internal.program.itree.StoreItree;
import org.kink_lang.kink.internal.program.itree.SymValPair;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itree.VarrefParam;
import org.kink_lang.kink.internal.program.itree.VarrefVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VecItree;

public final class DeepTransformer {
    private DeepTransformer() {
    }

    public static Itree deepTransform(Itree itree, Callback callback) {
        return itree.accept(new Visitor(callback));
    }

    private static class Visitor
    extends SkeltonItreeVisitor<Itree> {
        private static final LocalVar NEW_VAL_LVAR = new LocalVar.Original("new_val");
        private static final LocalVar IF_LVAR = new LocalVar.Original("if");
        private static final LocalVar BRANCH_LVAR = new LocalVar.Original("branch");
        private static final LocalVar TRUE_LVAR = new LocalVar.Original("true");
        private final Callback callback;

        Visitor(Callback callback) {
            super(callback::itree);
            this.callback = callback;
        }

        private Itree transformSub(Itree itree) {
            return itree.accept(this);
        }

        private ItreeElem transformElem(ItreeElem elem) {
            ItreeElem itreeElem;
            if (elem instanceof Itree) {
                Itree itree = (Itree)elem;
                itreeElem = this.transformSub(itree);
            } else {
                itreeElem = new ItreeElem.Spread(this.transformSub(elem.expr()), elem.pos());
            }
            return itreeElem;
        }

        private List<LocalVar> transformStoreLvars(List<LocalVar> lvars) {
            return lvars.stream().map(this.callback::storeLvar).toList();
        }

        private List<NestedParam> transformNestedParams(List<NestedParam> params) {
            return params.stream().map(p -> {
                NestedParam nestedParam;
                if (p instanceof NestedParam.Tuple) {
                    NestedParam.Tuple t = (NestedParam.Tuple)p;
                    nestedParam = new NestedParam.Tuple(this.transformStoreLvars(t.lvars()));
                } else {
                    nestedParam = this.callback.storeLvar((LocalVar)p);
                }
                return nestedParam;
            }).toList();
        }

        @Override
        public Itree visit(SeqItree itree) {
            List<Itree> steps = itree.steps().stream().map(this::transformSub).toList();
            return this.callback.itree(new SeqItree(steps, itree.pos()));
        }

        @Override
        public FastFunItree visit(FastFunItree itree) {
            return (FastFunItree)this.callback.itree(itree);
        }

        @Override
        public Itree visit(VecItree itree) {
            List<ItreeElem> elems = itree.elems().stream().map(this::transformElem).toList();
            return this.callback.itree(new VecItree(elems, itree.pos()));
        }

        @Override
        public Itree visit(DerefItree itree) {
            Itree owner = this.transformSub(itree.owner());
            return this.callback.itree(new DerefItree(owner, itree.sym(), itree.pos()));
        }

        @Override
        public Itree visit(LderefItree itree) {
            LocalVar lvar = this.callback.derefLvar(itree.lvar());
            return this.callback.itree(new LderefItree(lvar, itree.pos()));
        }

        @Override
        public Itree visit(VarrefItree itree) {
            Itree owner = this.transformSub(itree.owner());
            return this.callback.itree(new VarrefItree(owner, itree.sym(), itree.pos()));
        }

        @Override
        public Itree visit(LetRecItree itree) {
            List<LocalVar> lvars = itree.lvarFunPairs().stream().map(LetRecItree.LvarFunPair::lvar).map(this.callback::storeLvar).toList();
            List<FastFunItree> funs = itree.lvarFunPairs().stream().map(pair -> (FastFunItree)this.transformSub(pair.fun())).toList();
            ArrayList<LetRecItree.LvarFunPair> pairs = new ArrayList<LetRecItree.LvarFunPair>();
            for (int i = 0; i < lvars.size(); ++i) {
                pairs.add(new LetRecItree.LvarFunPair(lvars.get(i), funs.get(i)));
            }
            return this.callback.itree(new LetRecItree(pairs, itree.pos()));
        }

        @Override
        public Itree visit(AssignmentItree itree) {
            Itree lhs = this.transformSub(itree.lhs());
            Itree rhs = this.transformSub(itree.rhs());
            return this.callback.itree(new AssignmentItree(lhs, rhs, itree.pos()));
        }

        @Override
        public Itree visit(OptVecAssignmentItree itree) {
            Itree rhs = this.transformSub(itree.rhs());
            List<LocalVar> mandatory = itree.mandatory().stream().map(this.callback::storeLvar).toList();
            List<LocalVar> opt = itree.opt().stream().map(this.callback::storeLvar).toList();
            return this.callback.itree(new OptVecAssignmentItree(mandatory, opt, rhs, itree.pos()));
        }

        @Override
        public Itree visit(OptRestVecAssignmentItree itree) {
            Itree rhs = this.transformSub(itree.rhs());
            List<LocalVar> mandatory = itree.mandatory().stream().map(this.callback::storeLvar).toList();
            List<LocalVar> opt = itree.opt().stream().map(this.callback::storeLvar).toList();
            LocalVar rest = this.callback.storeLvar(itree.rest());
            return this.callback.itree(new OptRestVecAssignmentItree(mandatory, opt, rest, rhs, itree.pos()));
        }

        @Override
        public Itree visit(RestVecAssignmentItree itree) {
            Itree rhs = this.transformSub(itree.rhs());
            LocalVar lvar = this.callback.storeLvar(itree.lvar());
            return this.callback.itree(new RestVecAssignmentItree(lvar, rhs, itree.pos()));
        }

        @Override
        public Itree visit(NestedVecAssignmentItree itree) {
            Itree rhs = this.transformSub(itree.rhs());
            List<NestedParam> params = this.transformNestedParams(itree.params());
            return this.callback.itree(new NestedVecAssignmentItree(params, rhs, itree.pos()));
        }

        @Override
        public Itree visit(VarrefVecAssignmentItree itree) {
            List<VarrefParam> genericEvaluated = itree.params().stream().map(p -> {
                VarrefParam varrefParam;
                if (p instanceof GenericVar) {
                    GenericVar g = (GenericVar)p;
                    varrefParam = new GenericVar(this.transformSub(g.owner()), g.name());
                } else {
                    varrefParam = p;
                }
                return varrefParam;
            }).toList();
            Itree rhs = this.transformSub(itree.rhs());
            List<VarrefParam> params = genericEvaluated.stream().map(p -> {
                VarrefParam varrefParam;
                if (p instanceof LocalVar) {
                    LocalVar lvar = (LocalVar)p;
                    varrefParam = this.callback.storeLvar(lvar);
                } else {
                    varrefParam = p;
                }
                return varrefParam;
            }).toList();
            return this.callback.itree(new VarrefVecAssignmentItree(params, rhs, itree.pos()));
        }

        @Override
        public Itree visit(LstoreItree itree) {
            Itree rhs = this.transformSub(itree.rhs());
            LocalVar lvar = this.callback.storeLvar(itree.lvar());
            return this.callback.itree(new LstoreItree(lvar, rhs, itree.pos()));
        }

        @Override
        public Itree visit(StoreItree itree) {
            Itree owner = this.transformSub(itree.owner());
            Itree rhs = this.transformSub(itree.rhs());
            return this.callback.itree(new StoreItree(owner, itree.sym(), rhs, itree.pos()));
        }

        @Override
        public Itree visit(ArgsPassingItree itree) {
            List<LocalVar> lvars = this.transformStoreLvars(itree.lvars());
            return this.callback.itree(new ArgsPassingItree(lvars, itree.pos()));
        }

        @Override
        public Itree visit(NestedArgsPassingItree itree) {
            List<NestedParam> params = this.transformNestedParams(itree.params());
            return this.callback.itree(new NestedArgsPassingItree(params, itree.pos()));
        }

        @Override
        public Itree visit(BiArithmeticItree itree) {
            Itree recv = this.transformSub(itree.recv());
            return this.callback.itree(new BiArithmeticItree(recv, itree.op(), itree.arg(), itree.pos()));
        }

        @Override
        public Itree visit(NoTraitNewValItree itree) {
            LocalVar lvar = this.callback.derefLvar(NEW_VAL_LVAR);
            Preconds.checkState(lvar.equals(NEW_VAL_LVAR), "sym of new_val must not change");
            List<SymValPair> symValPairs = itree.symValPairs().stream().map(symVal -> new SymValPair(symVal.sym(), this.transformSub(symVal.val()))).toList();
            return this.callback.itree(new NoTraitNewValItree(symValPairs, itree.pos()));
        }

        @Override
        public Itree visit(TraitNewValItree itree) {
            LocalVar lvar = this.callback.derefLvar(NEW_VAL_LVAR);
            Preconds.checkState(lvar.equals(NEW_VAL_LVAR), "sym of new_val must not change");
            Itree trait = this.transformSub(itree.trait());
            List<SymValPair> symValPairs = itree.symValPairs().stream().map(pair -> new SymValPair(pair.sym(), this.transformSub(pair.val()))).toList();
            return this.callback.itree(new TraitNewValItree(trait, itree.spreadPos(), symValPairs, itree.pos()));
        }

        @Override
        public Itree visit(IfItree itree) {
            LocalVar lvar = this.callback.derefLvar(IF_LVAR);
            Preconds.checkState(lvar.equals(IF_LVAR), "sym of if must not change");
            Itree cond = this.transformSub(itree.cond());
            FastFunItree trueFun = (FastFunItree)this.transformSub(itree.trueFun());
            Optional<FastFunItree> falseFun = itree.falseFun().map(f -> (FastFunItree)this.transformSub((Itree)f));
            return this.callback.itree(new IfItree(cond, trueFun, falseFun, itree.pos()));
        }

        @Override
        public Itree visit(BranchItree itree) {
            LocalVar lvar = this.callback.derefLvar(BRANCH_LVAR);
            Preconds.checkState(lvar.equals(BRANCH_LVAR), "sym of branch must not change");
            List<CondThenPair> condThenPairs = itree.condThenPairs().stream().map(condThen -> new CondThenPair((FastFunItree)this.transformSub(condThen.condFun()), (FastFunItree)this.transformSub(condThen.thenFun()))).toList();
            return this.callback.itree(new BranchItree(condThenPairs, itree.pos()));
        }

        @Override
        public Itree visit(BranchWithElseItree itree) {
            LocalVar branchLvar = this.callback.derefLvar(BRANCH_LVAR);
            Preconds.checkState(branchLvar.equals(BRANCH_LVAR), "sym of branch must not change");
            LocalVar trueLvar = this.callback.derefLvar(TRUE_LVAR);
            Preconds.checkState(trueLvar.equals(TRUE_LVAR), "sym of true must not change");
            List<CondThenPair> condThenPairs = itree.condThenPairs().stream().map(condThen -> new CondThenPair((FastFunItree)this.transformSub(condThen.condFun()), (FastFunItree)this.transformSub(condThen.thenFun()))).toList();
            FastFunItree elseThenFun = (FastFunItree)this.transformSub(itree.elseThenFun());
            return this.callback.itree(new BranchWithElseItree(condThenPairs, elseThenFun, itree.pos()));
        }

        @Override
        public Itree visit(McallItree itree) {
            Itree ownerRecv = this.transformSub(itree.ownerRecv());
            List<ItreeElem> args = itree.args().stream().map(this::transformElem).toList();
            return this.callback.itree(new McallItree(ownerRecv, itree.sym(), args, itree.pos()));
        }

        @Override
        public Itree visit(SymcallItree itree) {
            Itree fun = this.transformSub(itree.fun());
            Itree recv = this.transformSub(itree.recv());
            List<ItreeElem> args = itree.args().stream().map(this::transformElem).toList();
            return this.callback.itree(new SymcallItree(fun, itree.sym(), recv, args, itree.pos()));
        }
    }

    public static interface Callback {
        public LocalVar derefLvar(LocalVar var1);

        public LocalVar storeLvar(LocalVar var1);

        public Itree itree(Itree var1);
    }
}

