/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.internal.program.itree.ArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.NadaItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.Operations;
import org.kink_lang.kink.internal.program.itreeoptimize.RecvArgsSearcher;

public class LetSymcallInliner
extends BaseOptimizer {
    @Override
    public Itree visit(FastFunItree fun) {
        ArgsPassingItree argsPassing;
        ItreeElem itreeElem;
        SymcallItree tailCall;
        int pos = fun.pos();
        List<Itree> steps = Operations.toSteps(fun.body());
        List<Itree> beforeTail = steps.subList(0, steps.size() - 1);
        Itree tail = steps.get(steps.size() - 1);
        if (!(tail instanceof SymcallItree) || !((tailCall = (SymcallItree)tail).recv() instanceof NadaItree)) {
            return fun;
        }
        List<ItreeElem> args = tailCall.args();
        if (args.size() != 1 || !((itreeElem = args.get(0)) instanceof Itree)) {
            return fun;
        }
        Itree arg = (Itree)itreeElem;
        Itree itree = tailCall.fun();
        if (!(itree instanceof FastFunItree)) {
            return fun;
        }
        FastFunItree tailFun = (FastFunItree)itree;
        List<Itree> tailSteps = Operations.toSteps(tailFun.body());
        Itree itree2 = tailSteps.get(0);
        if (!(itree2 instanceof ArgsPassingItree) || (argsPassing = (ArgsPassingItree)itree2).lvars().size() != 1) {
            return fun;
        }
        LocalVar lvar = argsPassing.lvars().get(0);
        List<Itree> afterStore = tailSteps.subList(1, tailSteps.size());
        if (afterStore.stream().anyMatch(RecvArgsSearcher::containsRecvOrArgs)) {
            return fun;
        }
        ArrayList<Itree> generatedSteps = new ArrayList<Itree>(beforeTail);
        generatedSteps.add(new LstoreItree(lvar, arg, pos));
        generatedSteps.addAll(afterStore);
        return new FastFunItree(new SeqItree(generatedSteps, pos), pos);
    }
}

