/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.kink_lang.kink.internal.program.itree.DeepTransformer;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itreeoptimize.OptimizerFactory;

public class RecursiveOptimizer
implements UnaryOperator<Itree> {
    private final List<OptimizerFactory> optimizerFactories;

    public RecursiveOptimizer(List<OptimizerFactory> optimizerFactories) {
        this.optimizerFactories = List.copyOf(optimizerFactories);
    }

    @Override
    public Itree apply(Itree org) {
        return DeepTransformer.deepTransform(org, new DeepTransformer.Callback(){

            @Override
            public LocalVar derefLvar(LocalVar lvar) {
                return lvar;
            }

            @Override
            public LocalVar storeLvar(LocalVar lvar) {
                return lvar;
            }

            @Override
            public Itree itree(Itree itree) {
                return itree.accept(new Visitor());
            }
        });
    }

    private RecursiveOptimizer makeBodyOptimizer(FastFunItree enclosing) {
        List<OptimizerFactory> subFactories = this.optimizerFactories.stream().map(factory -> factory.makeFactory(enclosing)).toList();
        return new RecursiveOptimizer(subFactories);
    }

    private Function<Itree, Itree> makeCompositeOptimizer() {
        Function<Itree, Itree> opt = Function.identity();
        for (OptimizerFactory factory : this.optimizerFactories) {
            opt = opt.andThen(factory.makeOptimizer());
        }
        return opt;
    }

    private class Visitor
    extends SkeltonItreeVisitor<Itree> {
        Visitor() {
            super(RecursiveOptimizer.this.makeCompositeOptimizer());
        }

        @Override
        public Itree visit(SlowFunItree itree) {
            Itree body = RecursiveOptimizer.this.apply(itree.body());
            return (Itree)super.visit(new SlowFunItree(body, itree.pos()));
        }

        @Override
        public Itree visit(FastFunItree itree) {
            RecursiveOptimizer bodyOptimizer = RecursiveOptimizer.this.makeBodyOptimizer(itree);
            Itree body = bodyOptimizer.apply(itree.body());
            return (Itree)super.visit(new FastFunItree(body, itree.pos()));
        }
    }
}

