/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.lex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kink_lang.kink.internal.function.Function4;
import org.kink_lang.kink.internal.program.lex.EotToken;
import org.kink_lang.kink.internal.program.lex.ErrorToken;
import org.kink_lang.kink.internal.program.lex.MarkToken;
import org.kink_lang.kink.internal.program.lex.NounToken;
import org.kink_lang.kink.internal.program.lex.NumToken;
import org.kink_lang.kink.internal.program.lex.StrToken;
import org.kink_lang.kink.internal.program.lex.Token;
import org.kink_lang.kink.internal.program.lex.VerbToken;

public class Lexer
implements Function<String, List<Token>> {
    private final List<TokenYielder> tokenYielders = List.of(new TokenYielder("HexInt", this::yieldHexInt), new TokenYielder("BinInt", this::yieldBinInt), new TokenYielder("Decimal", this::yieldDecimal), new TokenYielder("SimpleStr", this::yieldSimpleStr), new TokenYielder("RichStr", this::yieldRichStr), new TokenYielder("Noun", this::yieldNoun), new TokenYielder("Verb", this::yieldVerb), new TokenYielder("PseudoVar", this::yieldMark), new TokenYielder("Mark", this::yieldMark), new TokenYielder("Eot", this::yieldEot), new TokenYielder("TabError", this::yieldTabError), new TokenYielder("Unrecog", this::yieldUnrecog));
    private static final Pattern PAT = Pattern.compile("(?<Whitespace>([ \\r\\n]|#[^\\n]*)*)((?<HexInt>0x_*[0-9a-f][0-9a-f_]*(?<BadHexFollower>[g-zA-Z?])?)|(?<BinInt>0b_*[01][01_]*(?<BadBinFollower>[a-zA-Z2-9?])?)|(?<Decimal>[0-9][0-9_]*(\\.[0-9][0-9_]*)?(?<BadDecFollower>[a-zA-Z?])?)|(?<SimpleStr>'(''|[^'])*(?<SimpleStrCloser>')?)|(?<RichStr>\"(?<RsBody>([^\"\\\\]+|\\\\(x\\{[0-9a-f]{1,6}\\}|.))*)(?<RSCloser>\")?)|(?<Noun>([a-z_][a-z0-9_?]*)?[A-Z][a-zA-Z0-9_?]*)|(?<Verb>[a-z_][a-z0-9_?]*)|(?<PseudoVar>\\\\binding(?![a-zA-Z0-9_?]))|(?<Mark>\\.{3}|<[-<=]?|==?|!=?|\\|\\|?|&&?|>[>=]?|//?|[-+^~%*:$.\\[\\]{}()])|(?<Eot>)\\z|(?<TabError>\\t)|(?<Unrecog>))", 32);
    private static final Pattern RICHSTR_PAT = Pattern.compile("[^\"\\\\]+|\\\\(x\\{(?<Code>[0-9a-f]{1,6})\\}|(?<Special>.))", 32);

    public Lexer(Locale locale) {
    }

    private Token yieldHexInt(Integer start, Integer end, String fragment, Matcher matcher) {
        if (matcher.group("BadHexFollower") != null) {
            int pos = matcher.start("BadHexFollower");
            return new ErrorToken(this.getMsgNumCannotBeFollowedBySymLikeChar(), pos, pos);
        }
        BigInteger intNum = new BigInteger(fragment.replace("_", "").replace("x", ""), 16);
        return new NumToken(new BigDecimal(intNum), start, end);
    }

    private Token yieldBinInt(Integer start, Integer end, String fragment, Matcher matcher) {
        if (matcher.group("BadBinFollower") != null) {
            int pos = matcher.start("BadBinFollower");
            return new ErrorToken(this.getMsgNumCannotBeFollowedBySymLikeChar(), pos, pos);
        }
        BigInteger intNum = new BigInteger(fragment.replace("_", "").replace("b", ""), 2);
        return new NumToken(new BigDecimal(intNum), start, end);
    }

    private Token yieldDecimal(Integer start, Integer end, String fragment, Matcher matcher) {
        if (matcher.group("BadDecFollower") != null) {
            int pos = matcher.start("BadDecFollower");
            return new ErrorToken(this.getMsgNumCannotBeFollowedBySymLikeChar(), pos, pos);
        }
        BigDecimal decimal = new BigDecimal(fragment.replace("_", ""));
        return new NumToken(decimal, start, end);
    }

    private Token yieldSimpleStr(Integer start, Integer end, String fragment, Matcher matcher) {
        if (matcher.group("SimpleStrCloser") == null) {
            return new ErrorToken(this.getMsgStrNotClosed(), start, end);
        }
        String escapedContent = fragment.substring(1, fragment.length() - 1);
        String content = escapedContent.replace("''", "'");
        return new StrToken(content, start, end);
    }

    private Token yieldRichStr(Integer start, Integer end, String fragment, Matcher matcher) {
        if (matcher.group("RSCloser") == null) {
            return new ErrorToken(this.getMsgStrNotClosed(), start, end);
        }
        StringBuilder sb = new StringBuilder();
        Matcher bm = RICHSTR_PAT.matcher(matcher.group("RsBody"));
        while (bm.find()) {
            int unitStart = start + "\"".length() + bm.start();
            int unitEnd = start + "\"".length() + bm.end();
            if (bm.group("Special") != null) {
                String decoded = this.decodeSpecial(bm.group("Special").charAt(0));
                if (decoded == null) {
                    return new ErrorToken(this.getMsgWrongSpecialChar(), unitStart, unitEnd);
                }
                sb.append(decoded);
                continue;
            }
            if (bm.group("Code") != null) {
                int codePoint = Integer.parseInt(bm.group("Code"), 16);
                if (codePoint > 0x10FFFF) {
                    return new ErrorToken(this.getMsgCodeOutOfBound(), unitStart, unitEnd);
                }
                sb.appendCodePoint(codePoint);
                continue;
            }
            sb.append(bm.group(0));
        }
        return new StrToken(sb.toString(), start, end);
    }

    private String decodeSpecial(char ch) {
        return ch == '0' ? "\u0000" : (ch == 'a' ? "\u0007" : (ch == 'b' ? "\b" : (ch == 't' ? "\t" : (ch == 'n' ? "\n" : (ch == 'v' ? "\u000b" : (ch == 'f' ? "\f" : (ch == 'r' ? "\r" : (ch == 'e' ? "\u001b" : (ch == '\"' ? "\"" : (ch == '\\' ? "\\" : null))))))))));
    }

    private Token yieldNoun(Integer start, Integer end, String fragment, Matcher matcher) {
        return new NounToken(fragment, start, end);
    }

    private Token yieldVerb(Integer start, Integer end, String fragment, Matcher matcher) {
        return new VerbToken(fragment, start, end);
    }

    private Token yieldMark(Integer start, Integer end, String fragment, Matcher matcher) {
        boolean isAfterWhitespace = !matcher.group("Whitespace").isEmpty();
        return new MarkToken(fragment, start, end, isAfterWhitespace);
    }

    private Token yieldEot(Integer start, Integer end, String fragment, Matcher matcher) {
        return new EotToken(end);
    }

    private Token yieldTabError(Integer start, Integer end, String fragment, Matcher matcher) {
        int index = start;
        return new ErrorToken(this.getMsgTabDisallowed(), index, index);
    }

    private Token yieldUnrecog(Integer start, Integer end, String fragment, Matcher matcher) {
        int index = start;
        return new ErrorToken(this.getMsgUnrecogChar(), index, index);
    }

    @Override
    public List<Token> apply(String programText) {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        Matcher matcher = PAT.matcher(programText);
        do {
            matcher.find();
            token = this.tokenYielders.stream().filter(yielder -> yielder.accepts(matcher)).findFirst().map(yielder -> yielder.apply(matcher)).orElseThrow(AssertionError::new);
            tokens.add(token);
        } while (!(token instanceof EotToken) && !(token instanceof ErrorToken));
        return Collections.unmodifiableList(tokens);
    }

    final String getMsgNumCannotBeFollowedBySymLikeChar() {
        return "num cannot be directly followed by sym-like chars";
    }

    final String getMsgTabDisallowed() {
        return "tab cannot be used as a whitespace character";
    }

    final String getMsgUnrecogChar() {
        return "unrecognizable characters";
    }

    final String getMsgStrNotClosed() {
        return "str not closed";
    }

    final String getMsgWrongSpecialChar() {
        return "wrong special char";
    }

    final String getMsgCodeOutOfBound() {
        return "code must be in range U+000000..U+10ffff";
    }

    private static class TokenYielder {
        private final String groupName;
        private final Function4<Integer, Integer, String, Matcher, Token> fun;

        TokenYielder(String groupName, Function4<Integer, Integer, String, Matcher, Token> fun) {
            this.groupName = groupName;
            this.fun = fun;
        }

        boolean accepts(Matcher matcher) {
            return matcher.group(this.groupName) != null;
        }

        Token apply(Matcher matcher) {
            int start = matcher.start(this.groupName);
            int end = matcher.end(this.groupName);
            String fragment = matcher.group(this.groupName);
            return this.fun.apply(start, end, fragment, matcher);
        }
    }
}

