package org.kink_lang.kink;

import java.util.Locale;

import org.kink_lang.kink.hostfun.*;

/**
 * HostResultCore to raise an exception.
 */
class RaiseMessageResult extends HostResultCore
    implements CallFlowToRecv, CallFlowToArgs, CallFlowToOn, HostResult {

    /** The exception message. */
    private final String msg;

    /**
     * Constructs a reaction.
     */
    RaiseMessageResult(String msg) {
        this.msg = msg;
    }

    /**
     * Returns the exception message.
     */
    String getMsg() {
        return this.msg;
    }

    @Override
    public CallFlowToArgs recv(Val recv) {
        return this;
    }

    @Override
    public CallFlowToOn args() {
        return this;
    }

    @Override
    public CallFlowToOn args(Val a0) {
        return this;
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1) {
        return this;
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1, Val a2) {
        return this;
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1, Val a2, Val a3) {
        return this;
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1, Val a2, Val a3, Val a4) {
        return this;
    }

    @Override
    public CallFlowToOn args(Val... args) {
        return this;
    }

    @Override
    public HostResult on(HostFunReaction reaction) {
        return this;
    }

    @Override
    void doTransition(StackMachine stackMachine) {
        Vm vm = stackMachine.getVm();
        var traces = stackMachine.getCallStack().traces().stream()
            .map(traceFrame -> traceFrame.toTraceVal(vm))
            .toList();
        stackMachine.transitionToRaiseException(vm.exception.of(this.msg, traces));
    }

    @Override
    public HostResultCore makeHostResultCore() {
        return this;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "RaiseMessageResult(%s)", this.msg);
    }

    @Override
    public int hashCode() {
        return this.msg.hashCode();
    }

    @Override
    public boolean equals(Object arg) {
        return arg == this
            || arg instanceof RaiseMessageResult
            && this.msg.equals(((RaiseMessageResult) arg).msg);
    }

}

// vim: et sw=4 sts=4 fdm=marker
