package org.kink_lang.kink.internal.compile.bootstrap;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Vm;

/**
 * Interning registry of str vals.
 */
final class StrRegistry {

    /** The vm. */
    private final Vm vm;

    /** The map of str vals. */
    private final ConcurrentMap<String, StrVal> map = new ConcurrentHashMap<>();

    /**
     * Constructs a registry.
     */
    private StrRegistry(Vm vm) {
        this.vm = vm;
    }

    /**
     * Returns the str val.
     */
    static StrVal strVal(Vm vm, String string) {
        StrRegistry registry = vm.component.getOrRegister(StrRegistry.class, StrRegistry::new);
        return registry.strVal(string);
    }

    /**
     * Returns the str val.
     */
    private StrVal strVal(String string) {
        return this.map.computeIfAbsent(string, s -> vm.str.of(s.intern()));
    }

}

// vim: et sw=4 sts=4 fdm=marker
