package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.List;
import java.util.function.BiFunction;

import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;

/**
 * Generates insns of controls.
 */
public interface ControlGenerator {

    /**
     * Generates insns of {@code if} preloaded fun.
     *
     * @param itree the itree to compile.
     * @param generate generates insns of sub expressions.
     * @param resultCtx the result context of {@code if}.
     * @return insns.
     */
    List<Insn> preloadedIf(
            IfItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate,
            ResultContext resultCtx);

    /**
     * Generates insns of branch without else.
     *
     * @param itree the itree to compile.
     * @param generate generates insns of sub expressions.
     * @param resultCtx the result context of branch.
     * @return insns.
     */
    List<Insn> branch(
            BranchItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate,
            ResultContext resultCtx);

    /**
     * Generates insns of branch with else.
     *
     * @param itree the itree to compile.
     * @param generate generates insns of sub expressions.
     * @param resultCtx the result context of branch.
     * @return insns.
     */
    List<Insn> branchWithElse(
            BranchWithElseItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate,
            ResultContext resultCtx);

    /**
     * Generates insns of new_val with trait.
     *
     * @param itree the itree to compile.
     * @param generate generates insns of sub expressions.
     * @param resultCtx the result context of new_val.
     * @return insns.
     */
    List<Insn> traitNewVal(
            TraitNewValItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate,
            ResultContext resultCtx);

    /**
     * Generates insns of new_val without trait.
     *
     * @param itree the itree to compile.
     * @param generate generates insns of sub expressions.
     * @param resultCtx the result context of new_val.
     * @return insns.
     */
    List<Insn> noTraitNewVal(
            NoTraitNewValItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate,
            ResultContext resultCtx);

}

// vim: et sw=4 sts=4 fdm=marker
