package org.kink_lang.kink.internal.compile.javaclassir;

import org.kink_lang.kink.internal.callstack.Trace;

/**
 * Supplies program counters.
 */
public class ProgramCounterSupplier {

    /** The trace accumulator. */
    private final TraceAccumulator traceAccum;

    /** The program counter for the next invocation of newProgramCounter. */
    private int nextProgramCounter = 1;

    /**
     * Constructs a supplier.
     *
     * @param traceAccum the trace accumulator.
     */
    public ProgramCounterSupplier(TraceAccumulator traceAccum) {
        this.traceAccum = traceAccum;
    }

    /**
     * Supplies a new program counter with a trace.
     *
     * @param trace the trace associated with the program counter.
     * @return the new program counter.
     */
    public int newProgramCounter(Trace trace) {
        int programCounter = this.nextProgramCounter;
        this.traceAccum.put(programCounter, trace);
        ++ this.nextProgramCounter;
        return programCounter;
    }

}

// vim: et sw=4 sts=4 fdm=marker
