package org.kink_lang.kink.internal.program.ast;

/**
 * A fun expression.
 *
 * @param body   the fun body.
 * @param pos    the start pos of the node.
 */
public record FunExpr(Expr body, int pos) implements Expr {

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitFun(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
