package org.kink_lang.kink.internal.program.itree;

/**
 * Itree of an assignment.
 *
 * <p>The purpose of this itree class is to simplify optimization to LstoreItree,
 * StoreItree, ArgsPassingItree and so on.</p>
 *
 * @param lhs the lhs of the assignment.
 * @param rhs the rhs of the assignment.
 * @param pos the pos of the assignment.
 */
public record AssignmentItree(Itree lhs, Itree rhs, int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
