package org.kink_lang.kink.internal.program.itree;

/**
 * Itree (intermediate tree) representation of Kink programs.
 *
 * <p>Usually, itrees are translated from AST representation,
 * and after optimization is applied,
 * they are translated into instruction sequence.
 * By existence of itree representation,
 * ASTs can be separated from evaluation details.</p>
 *
 * <p>Itree is similar to GENERIC/GIMPLE in GCC.</p>
 */
public non-sealed interface Itree extends ItreeElem {

    /**
     * Returns the pos of the itree on the program text.
     *
     * @return the pos of the itree on the program text.
     */
    @Override
    int pos();

    /**
     * Accepts a visitor.
     *
     * @param visitor the visitor.
     * @param <T> the result type of the visitor.
     * @return the result of the visitor.
     */
    <T> T accept(ItreeVisitor<T> visitor);

    @Override
    default Itree expr() {
        return this;
    }

    @Override default boolean isSingle() {
        return true;
    }

}

// vim: et sw=4 sts=4 fdm=marker
