package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * Itree of new_val(... Trait 'X' x 'Y' y).
 *
 * @param trait     the itree of the expected trait, which is spreaded on the head.
 * @param spreadPos the pos of the spreading of the trait.
 * @param symValPairs sym-val pairs.
 * @param pos       the pos index of the itree.
 */
public record TraitNewValItree(Itree trait, int spreadPos,
                               List<SymValPair> symValPairs,
                               int pos) implements Itree {

    /**
     * Constructs an itree.
     * <p>
     * syms and vals must have the same size.
     *
     * @param trait     the itree of the expected trait, which is spreaded on the head.
     * @param spreadPos the pos of the spreading of the trait.
     * @param symValPairs sym-val pairs.
     * @param pos       the pos index of the itree.
     */
    public TraitNewValItree {
        symValPairs = List.copyOf(symValPairs);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
