package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.Optional;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Converts expression like {@code [:X :Y] <- \args} to ArgsPassingItree.
 */
public class ArgsPassingOptimizer
    extends TemplateArgsPassingOptimizer<OptVecAssignmentItree, ArgsPassingItree> {

    @Override
    Optional<OptVecAssignmentItree> testReplaceable(Itree itree) {
        return itree instanceof OptVecAssignmentItree assignment
            && assignment.opt().isEmpty()
            ? Optional.of(assignment)
            : Optional.empty();
    }

    @Override
    ArgsPassingItree convert(OptVecAssignmentItree assignment) {
        return new ArgsPassingItree(assignment.mandatory(), assignment.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
