package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.McallItree;

/**
 * Optimizes a mcall like {@code X <- Y} to AssignmentItree.
 */
public class AssignmentOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(McallItree mcall) {
        if (! isOptimizable(mcall)) {
            return mcall;
        }

        Itree lhs = mcall.ownerRecv();
        Itree rhs = mcall.args().get(0).expr();
        return new AssignmentItree(lhs, rhs, mcall.pos());
    }

    /**
     * Whether {@code mcall} is optimizable.
     */
    private boolean isOptimizable(McallItree mcall) {
        return mcall.sym().equals("op_store")
            && isUnarySingleArg(mcall.args());
    }

    /**
     * Whether {@code args} contains only one single elem.
     */
    private boolean isUnarySingleArg(List<ItreeElem> args) {
        return args.size() == 1
            && args.get(0).isSingle();
    }

}

// vim: et sw=4 sts=4 fdm=marker
