package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Eliminates lstore to unused lvars.
 */
public class DeadLstoreEliminator extends BaseOptimizer {

    /** The enclosing fun. */
    private final UsedDefinedVars enclosing;

    /**
     * Constructs an optimizer.
     *
     * @param enclosing the enclosing fun.
     */
    public DeadLstoreEliminator(UsedDefinedVars enclosing) {
        this.enclosing = enclosing;
    }

    @Override
    public Itree visit(LstoreItree lstore) {
        if (this.enclosing.isUsed(lstore.lvar())) {
            return lstore;
        }

        int pos = lstore.pos();
        return new SeqItree(List.of(
                    lstore.rhs(),
                    new NadaItree(pos)), pos);
    }

}

// vim: et sw=4 sts=4 fdm=marker
