package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Remove assignment from letrec if the lvar is not used.
 */
public class LetRecReducer extends BaseOptimizer {

    /** The binding of the env. */
    private final UsedDefinedVars enclosing;

    /**
     * Constructs an optimizer.
     *
     * @param enclosing the enclosing fun.
     */
    public LetRecReducer(UsedDefinedVars enclosing) {
        this.enclosing = enclosing;
    }

    @Override
    public Itree visit(LetRecItree letrec) {
        List<LetRecItree.LvarFunPair> pairs = letrec.lvarFunPairs().stream()
            .filter(pair -> this.enclosing.isUsed(pair.lvar()))
            .toList();
        int pos = letrec.pos();
        return pairs.isEmpty() ? new NadaItree(pos) : new LetRecItree(pairs, pos);
    }

}

// vim: et sw=4 sts=4 fdm=marker
