package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.Optional;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Converts expression like {@code [:X :Y] <- \args} to ArgsPassingItree.
 */
public class NestedArgsPassingOptimizer
    extends TemplateArgsPassingOptimizer<NestedVecAssignmentItree, NestedArgsPassingItree> {

    @Override
    Optional<NestedVecAssignmentItree> testReplaceable(Itree itree) {
        return itree instanceof NestedVecAssignmentItree assignment
            ? Optional.of(assignment)
            : Optional.empty();
    }

    @Override
    NestedArgsPassingItree convert(NestedVecAssignmentItree assignment) {
        return new NestedArgsPassingItree(assignment.params(), assignment.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
