package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.stream.Collectors;

import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.OptRestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VecItree;

/**
 * Optimizes {@code [:A :B :C.opt :D.opt :Rest.rest] <- xxx} to OptRestVecAssignmentItree.
 */
public class OptRestVecAssignmentOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(AssignmentItree itree) {
        Itree lhs = itree.lhs();
        if (! (lhs instanceof VecItree)) {
            return itree;
        }

        List<ItreeElem> params = ((VecItree) lhs).elems();
        if (params.isEmpty()) {
            return itree;
        }

        // [,,, :Rest.rest]
        ItreeElem last = params.get(params.size() - 1);
        if (! Params.isRestParam(last)) {
            return itree;
        }
        String restSym = Params.getRestParamSym(last);

        List<ItreeElem> beforeLast = params.subList(0, params.size() - 1);

        // [:A :B ,,,]
        List<LocalVar> mandatory = beforeLast.stream()
            .takeWhile(Params::isMandatoryParam)
            .map(Params::getMandatoryParamSym)
            .map(LocalVar.Original::new)
            .collect(Collectors.toList());

        // [,,, :C.opt :D.opt ,,,]
        List<ItreeElem> expOptParams = beforeLast.subList(mandatory.size(), beforeLast.size());
        if (! expOptParams.stream().allMatch(Params::isOptParam)) {
            return itree;
        }
        List<LocalVar> opt = expOptParams.stream()
            .map(Params::getOptParamSym)
            .map(LocalVar.Original::new)
            .collect(Collectors.toList());

        return new OptRestVecAssignmentItree(
                mandatory,
                opt,
                new LocalVar.Original(restSym),
                itree.rhs(),
                itree.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
