package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Function;
import java.util.function.UnaryOperator;

import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;

/**
 * Produces an optimizer which is applied only to the top level
 * and slow fun bodies.
 */
class SlowFunBodyOptimizerFactory implements OptimizerFactory {

    /** The current optimizer. */
    private final Function<? super Itree, ? extends Itree> optimizer;

    /**
     * Constructs a factory.
     */
    SlowFunBodyOptimizerFactory(Function<? super Itree, ? extends Itree> optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public OptimizerFactory makeFactory(FastFunItree fun) {
        return new ConstantOptimizerFactory(UnaryOperator.identity());
    }

    @Override
    public Function<? super Itree, ? extends Itree> makeOptimizer() {
        return this.optimizer;
    }

}

// vim: et sw=4 sts=4 fdm=marker
