package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.stream.Collectors;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Optimizes a VarrefVecAssignmentItree to a better form.
 */
public class VarrefVecAssignmentToLocalOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(VarrefVecAssignmentItree assignment) {
        // generic -> local
        List<VarrefParam> params = assignment.params().stream()
            .map(param -> param instanceof GenericVar gp
                    && gp.owner() instanceof BindingItree
                    ? new LocalVar.Original(gp.name())
                    : param)
            .collect(Collectors.toList());

        // -> OptVecAssignmentItree
        boolean allLocal = params.stream().allMatch(vp -> vp instanceof LocalVar);
        if (allLocal) {
            List<LocalVar> lvars = params.stream()
                .map(VarrefParam::name)
                .map(LocalVar.Original::new)
                .collect(Collectors.toList());
            return new OptVecAssignmentItree(
                    lvars,
                    List.of(),
                    assignment.rhs(),
                    assignment.pos());
        } else {
            return new VarrefVecAssignmentItree(params, assignment.rhs(), assignment.pos());
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
