package org.kink_lang.kink;

import java.util.Locale;

/**
 * A fun val.
 */
public abstract class FunVal extends Val {

    /**
     * Constructs a fun val.
     *
     * @param vm the vm.
     */
    FunVal(Vm vm) {
        super(vm, null);
    }

    @Override
    SharedVars sharedVars() {
        return vm.fun.sharedVars;
    }

    /**
     * Runs the function on the stack machine.
     *
     * <p>The method must call one of {@code transitionToXXx} of the {@link StackMachine}.</p>
     */
    abstract void run(StackMachine stackMachine);

    /**
     * Returns the string of {@code Fun.repr}.
     */
    String getRepr() {
        return String.format(Locale.ROOT,
                "(fun variant=%s val_id=%s)",
                getClass().getSimpleName(),
                identity());
    }

}

// vim: et sw=4 sts=4 fdm=marker
