package org.kink_lang.kink;

import java.util.Locale;

import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostFunAction;
import org.kink_lang.kink.hostfun.HostResult;

/**
 * A fun to do an make in Java code.
 *
 * <p>The function run delegates its make to {@code make.apply(c)}.</p>
 *
 * <p>Use {@link FunHelper#make()} to make a fun of this class.</p>
 */
final class HostFunVal extends FunVal {

    /** The make of the fun. */
    private final HostFunAction action;

    /** The description of the fun. */
    private final String desc;

    /**
     * Constructs a fun.
     */
    HostFunVal(Vm vm, String desc, HostFunAction action) {
        super(vm);
        this.action = action;
        this.desc = desc;
    }

    @Override
    String getRepr() {
        return String.format(Locale.ROOT,
                "(fun val_id=%s variant=%s _desc=%s)",
                identity(),
                getClass().getSimpleName(),
                this.desc);
    }

    @Override
    void run(StackMachine stackMachine) {
        CallContext c = stackMachine.nextCallContext();
        HostResult hostResult;
        try {
            hostResult = action.action(c);
        } catch (Throwable th) {
            stackMachine.transitionToRaiseThrowable(th);
            return;
        }
        stackMachine.transitionToHostResult(hostResult.makeHostResultCore());
    }

}

// vim: et sw=4 sts=4 fdm=marker
