package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.List;

import org.objectweb.asm.Type;

import org.kink_lang.kink.Val;

/**
 * Generates insns of {@code \binding}.
 */
@FunctionalInterface
public interface BindingGenerator {

    /**
     * Returns the insns.
     *
     * @return the insns.
     */
    List<Insn> generateBinding();

    /**
     * In a slow fun, the binding is stored in the stack; just after args.
     */
    BindingGenerator STACK = () -> List.of(
            InsnsGenerator.LOAD_DATASTACK,
            InsnsGenerator.LOAD_ARGCOUNT,
            new Insn.PushInt(1),
            new Insn.AddInt(),
            InsnsGenerator.INVOKE_AT_OFFSET);

    /**
     * In a top level fun, the binding is stored in valField0 field.
     */
    BindingGenerator FIELD = () -> List.of(
            new Insn.LoadThis(),
            new Insn.GetField(JavaClassIr.TYPE_BASE, "valField0", Type.getType(Val.class)));

    /**
     * In a fast fun, the binding should not be produced.
     */
    BindingGenerator NOT_AVAILABLE = () -> {
        throw new UnsupportedOperationException("\\binding is N/A in fast fun");
    };

}

// vim: et sw=4 sts=4 fdm=marker
