package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.List;

import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

/**
 * Provides support methods for compilation.
 */
public final class CompilerSupport {

    /**
     * Must not instantiate.
     */
    private CompilerSupport() {
    }

    /** Insn of invoking DataStack.increaseSp. */
    private static final Insn INVOKE_INCREASE_SP = new Insn.InvokeVirtual(
            InsnsGenerator.DATASTACK_TYPE,
            new Method("increaseSp", Type.VOID_TYPE, new Type[] { Type.INT_TYPE }));

    /** Insn of loading programCounter. */
    private static final Insn LOAD_PROGRAMCOUNTER = new Insn.LoadArg(2);

    /** Prologue of doResume. */
    static final List<Insn> PROLOGUE = List.of(
            LOAD_PROGRAMCOUNTER,
            new Insn.Switch(InsnsGenerator.PROGRAMCOUNTER_KEY),
            new Insn.Case(InsnsGenerator.PROGRAMCOUNTER_KEY, 0));

    /** Epilogue of doResume. */
    static final List<Insn> EPILOGUE = List.of(
            new Insn.Default(InsnsGenerator.PROGRAMCOUNTER_KEY),
            new Insn.Throw(Type.getType(AssertionError.class), "should not reach here"));

    /**
     * Allocates vals on on the data stack.
     */
    static List<Insn> allocateStack(int stackLvars) {
        return stackLvars == 0
            ? List.of()

            // dataStack.increaseSp(number of stack bound lvars)
            : List.of(InsnsGenerator.LOAD_DATASTACK,
                    new Insn.PushInt(stackLvars),
                    INVOKE_INCREASE_SP);
    }

}

// vim: et sw=4 sts=4 fdm=marker
