package org.kink_lang.kink.internal.program.itree;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Itree for args passing such as {@code [:X :Y :Z] <- \args}.
 *
 * @param lvars the local vars; ex. (X, Y, Z) for {@code [:X :Y :Z] <- \args}.
 * @param pos the pos of the args passing.
 */
public record ArgsPassingItree(List<LocalVar> lvars, int pos) implements Itree {

    /**
     * Constructs an args passing itree.
     *
     * @param lvars the local vars; ex. (X, Y, Z) for {@code [:X :Y :Z] <- \args}.
     * @param pos the pos of the args passing.
     */
    public ArgsPassingItree {
        lvars = List.copyOf(lvars);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    /**
     * Returns the representation of the left-hand-side.
     *
     * @return the representation of the left-hand-side.
     */
    public String lhsRepr() {
        return lvars().stream()
            .map(LocalVar::lhsRepr)
            .collect(Collectors.joining(" ", "[", "]"));
    }

}

// vim: et sw=4 sts=4 fdm=marker
