package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * Letrec itree.
 *
 * @param lvarFunPairs pairs of local vars and the corresponding funs.
 * @param pos   the pos index of the itree.
 */
public record LetRecItree(List<LvarFunPair> lvarFunPairs, int pos) implements Itree {

    /**
     * Pair of local var and the corresponding fun.
     *
     * @param lvar the local var.
     * @param fun the fun corresponding to the local var.
     */
    public record LvarFunPair(LocalVar lvar, FastFunItree fun) {}

    /**
     * Constructs an itree.
     *
     * @param lvarFunPairs pairs of local vars and the corresponding funs.
     * @param pos   the pos index of the itree.
     */
    public LetRecItree {
        lvarFunPairs = List.copyOf(lvarFunPairs);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
