package org.kink_lang.kink.internal.program.itree;

/**
 * Assignment to a vec in the form {@code [:R.rest] <- xxx}.
 *
 * @param lvar the local var of the rest param.
 * @param rhs  the right-hand-side.
 * @param pos  the pos index of the itree.
 */
public record RestVecAssignmentItree(LocalVar lvar, Itree rhs,
                                     int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
