package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Function;

import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;

/**
 * A factory which always produces a constant optimizer.
 */
class ConstantOptimizerFactory implements OptimizerFactory {

    /** The constant optimizer. */
    private final Function<? super Itree, ? extends Itree> optimizer;

    /**
     * Makes a factory.
     */
    ConstantOptimizerFactory(Function<? super Itree, ? extends Itree> optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public OptimizerFactory makeFactory(FastFunItree enclosing) {
        return this;
    }

    @Override
    public Function<? super Itree, ? extends Itree> makeOptimizer() {
        return this.optimizer;
    }

}

// vim: et sw=4 sts=4 fdm=marker
