package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.SeqItree;

/**
 * Reduces a one step seq to an expression, removing the parentheses.
 *
 * <p>This optimizer itself does no good for performance,
 * but it enables further optimizations.</p>
 */
public class DeparenOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(SeqItree seq) {
        return seq.steps().size() == 1
            ? seq.steps().get(0)
            : seq;
    }

}

// vim: et sw=4 sts=4 fdm=marker
