package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Function;

import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;

/**
 * Factory of itree optimizers.
 */
interface OptimizerFactory {

    /**
     * Makes a child factory with {@code enclosing} as the enclosing context.
     *
     * @param enclosing the enclosing context.
     * @return a child factory.
     */
    public abstract OptimizerFactory makeFactory(FastFunItree enclosing);

    /**
     * Makes an optimizer.
     *
     * @return an optimizer.
     */
    public abstract Function<? super Itree, ? extends Itree> makeOptimizer();

}

// vim: et sw=4 sts=4 fdm=marker
