package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Composite optimizer which applies the component optimizers until it reaches the fixed point.
 */
public class RepetitiveOptimizer implements UnaryOperator<Itree> {

    /** The component optimizer. */
    private final List<? extends Function<? super Itree, ? extends Itree>> componentOptimizers;

    /**
     * Constructs a composite optimizer.
     *
     * @param componentOptimizers the list of optimizers which are applied repetitively.
     */
    public RepetitiveOptimizer(
            List<? extends Function<? super Itree, ? extends Itree>> componentOptimizers) {
        this.componentOptimizers = componentOptimizers;
    }

    @Override
    public Itree apply(Itree org) {
        Itree cur = org;
        while (true) {
            Itree prev = cur;

            for (Function<? super Itree, ? extends Itree> opt : componentOptimizers) {
                cur = opt.apply(cur);
            }

            if (cur.equals(prev)) {
                return cur;
            }
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
