/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;

public class BinVal
extends Val
implements Comparable<BinVal> {
    private BytesNode bytesNode;

    BinVal(Vm vm, byte[] bytes) {
        this(vm, new BytesLeaf(bytes));
    }

    private BinVal(Vm vm, BytesNode bytesNode) {
        super(vm, null);
        Preconds.checkArg(bytesNode.size() <= vm.bin.getMaxSize(), "size must not exceed getMaxSize()");
        this.bytesNode = bytesNode;
    }

    public int size() {
        return this.bytesNode.size();
    }

    public byte[] bytes() {
        return Arrays.copyOf(this.rawBytes(), this.size());
    }

    public void copyToBytes(int from, int to, byte[] bytes, int at) {
        int length = to - from;
        System.arraycopy(this.rawBytes(), from, bytes, at, length);
    }

    private byte[] rawBytes() {
        BytesLeaf leaf = this.bytesNode.asLeaf();
        this.bytesNode = leaf;
        return leaf.getBytes();
    }

    public byte get(int ind) {
        Preconds.checkElemIndex(ind, this.size());
        return this.rawBytes()[ind];
    }

    public ByteBuffer readOnlyByteBuffer() {
        ByteBuffer mutBuf = ByteBuffer.wrap(this.rawBytes());
        return mutBuf.asReadOnlyBuffer();
    }

    public BinVal slice(int from, int to) {
        Preconds.checkRange(from, to, this.size());
        return new BinVal(this.vm, Arrays.copyOfRange(this.rawBytes(), from, to));
    }

    @Override
    public int compareTo(BinVal arg) {
        return Arrays.compareUnsigned(this.rawBytes(), arg.rawBytes());
    }

    public BinVal concat(BinVal tail) {
        Preconds.checkArg((long)this.size() + (long)tail.size() <= (long)this.vm.bin.getMaxSize(), "result size exceeds the max");
        if (this.size() == 0) {
            return tail;
        }
        if (tail.size() == 0) {
            return this;
        }
        BytesNode left = this.bytesNode;
        BytesNode right = tail.bytesNode;
        int leafCountSum = left.getLeafCount() + right.getLeafCount();
        return leafCountSum < 128 ? new BinVal(this.vm, new BytesTree(left, right)) : new BinVal(this.vm, BytesLeaf.concat(List.of(right, left)));
    }

    public boolean equals(Object arg) {
        return arg == this || arg instanceof BinVal && this.vm.equals(((BinVal)arg).vm) && Arrays.equals(this.rawBytes(), ((BinVal)arg).rawBytes());
    }

    public int hashCode() {
        return this.vm.hashCode() * 101 + Arrays.hashCode(this.rawBytes());
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ", "BinVal(", ")");
        for (byte b : this.rawBytes()) {
            String s = Integer.toString(Byte.toUnsignedInt(b), 16);
            sj.add((s.length() == 1 ? "0x0" : "0x") + s);
        }
        return sj.toString();
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.bin.sharedVars;
    }

    private static class BytesLeaf
    extends BytesNode {
        private final byte[] bytes;

        BytesLeaf(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        int size() {
            return this.bytes.length;
        }

        @Override
        int getLeafCount() {
            return 1;
        }

        @Override
        BytesLeaf asLeaf() {
            return this;
        }

        byte[] getBytes() {
            return this.bytes;
        }

        static BytesLeaf concat(List<BytesNode> initialStack) {
            int size = initialStack.stream().mapToInt(BytesNode::size).sum();
            ArrayList<BytesNode> stack = new ArrayList<BytesNode>(initialStack);
            int ind = 0;
            byte[] result = new byte[size];
            while (!stack.isEmpty()) {
                BytesNode node = (BytesNode)stack.remove(stack.size() - 1);
                if (node instanceof BytesLeaf) {
                    BytesLeaf leaf = (BytesLeaf)node;
                    System.arraycopy(leaf.getBytes(), 0, result, ind, leaf.size());
                    ind += leaf.size();
                    continue;
                }
                BytesTree tree = (BytesTree)node;
                stack.add(tree.right);
                stack.add(tree.left);
            }
            return new BytesLeaf(result);
        }
    }

    private static abstract class BytesNode {
        private BytesNode() {
        }

        abstract int size();

        abstract int getLeafCount();

        abstract BytesLeaf asLeaf();
    }

    private static class BytesTree
    extends BytesNode {
        private final int size;
        private final int leafCount;
        private final BytesNode left;
        private final BytesNode right;

        BytesTree(BytesNode left, BytesNode right) {
            this.size = left.size() + right.size();
            this.leafCount = left.getLeafCount() + right.getLeafCount();
            this.left = left;
            this.right = right;
        }

        @Override
        int size() {
            return this.size;
        }

        @Override
        int getLeafCount() {
            return this.leafCount;
        }

        @Override
        BytesLeaf asLeaf() {
            return BytesLeaf.concat(List.of(this));
        }
    }
}

