/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.Map;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;

public class BoolHelper {
    private final Vm vm;
    public final Val trueVal;
    public final Val falseVal;
    private SharedVars boolVars;

    BoolHelper(Vm vm) {
        this.vm = vm;
        this.trueVal = new Val(this, vm, null){

            public String toString() {
                return "trueVal";
            }

            @Override
            SharedVars sharedVars() {
                return this.vm.bool.boolVars;
            }
        };
        this.falseVal = new Val(this, vm, null){

            public String toString() {
                return "falseVal";
            }

            @Override
            SharedVars sharedVars() {
                return this.vm.bool.boolVars;
            }
        };
    }

    public Val of(boolean bl) {
        return bl ? this.trueVal : this.falseVal;
    }

    public boolean isBool(Val val) {
        return val == this.trueVal || val == this.falseVal;
    }

    void init() {
        this.boolVars = this.vm.sharedVars.of(Map.of(this.vm.sym.handleFor("op_eq"), this.vm.fun.make("Bool1.op_eq(Bool2)").take(1).action(this::opEqMethod), this.vm.sym.handleFor("repr"), this.vm.fun.make("Bool.repr").take(0).action(this::reprMethod)));
    }

    private HostResult opEqMethod(CallContext c) {
        Val arg = c.arg(0);
        if (!this.vm.bool.isBool(arg)) {
            return c.call(this.vm.graph.raiseFormat("Bool1.op_eq(Bool2): Bool2 must be a bool, but got {}", this.vm.graph.repr(arg)));
        }
        return this.vm.bool.of(arg.equals(c.recv()));
    }

    private HostResult reprMethod(CallContext c) {
        Val recv = c.recv();
        if (!this.vm.bool.isBool(recv)) {
            return c.call(this.vm.graph.raiseFormat("Bool.repr: Bool must be a bool, but got {}", this.vm.graph.repr(recv)));
        }
        return this.vm.str.of(recv == this.vm.bool.trueVal ? "true" : "false");
    }
}

