/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.kink_lang.kink.ExceptionVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StackMachine;
import org.kink_lang.kink.TraceVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.internal.function.ThrowingFunction3;

public class ExceptionHelper {
    private final Vm vm;
    SharedVars sharedVars;
    private int descIterHandle;

    ExceptionHelper(Vm vm) {
        this.vm = vm;
    }

    void init() {
        this.descIterHandle = this.vm.sym.handleFor("_desc_iter");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addMethod0(vars, "Exception", "message", (c, exc) -> this.vm.str.of(exc.message()));
        this.addMethod0(vars, "Exception", "traces", (c, exc) -> this.vm.vec.of(exc.traces()));
        this.addMethod0(vars, "Exception", "have_next?", (c, exc) -> this.vm.bool.of(exc.next().isPresent()));
        this.addMethod0(vars, "Exception", "next", this::nextMethod);
        this.addMethod0(vars, "Exception", "raise", this::raiseMethod);
        this.addBinaryOp(vars, "Exception", "op_add", "Tail", this::opAddMethod);
        this.addMethod0(vars, "Exception", "desc_iter", this::descIterMethod);
        this.addMethod0(vars, "Exception", "repr", this::reprMethod);
        this.addBinaryOp(vars, "Exception", "op_eq", "Arg_exception", this::opEqMethod);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    public ExceptionVal of(String message, List<? extends TraceVal> traces) {
        return new ExceptionVal(this.vm, message, traces);
    }

    public ExceptionVal of(Throwable th) {
        List<Throwable> throwables = ExceptionHelper.flatten(th);
        ExceptionVal tail = null;
        for (int i = throwables.size() - 1; i >= 0; --i) {
            tail = this.ofFlat(throwables.get(i), tail);
        }
        return tail;
    }

    ExceptionVal ofFlat(Throwable th, @Nullable ExceptionVal tail) {
        StackTraceElement[] stes = th.getStackTrace();
        ArrayList<TraceVal> traces = new ArrayList<TraceVal>(stes.length);
        for (int i = stes.length - 1; i >= 0; --i) {
            StackTraceElement ste = stes[i];
            traces.add(this.vm.trace.of(ste.toString()));
        }
        ExceptionVal head = this.of(th.toString(), traces);
        return tail == null ? head : head.chain(tail);
    }

    static List<Throwable> flatten(Throwable th) {
        ArrayList<Throwable> accum = new ArrayList<Throwable>();
        ExceptionHelper.flattenTraverse(th, accum);
        return Collections.unmodifiableList(accum);
    }

    private static void flattenTraverse(@Nullable Throwable th, List<Throwable> accum) {
        if (th == null || accum.contains(th)) {
            return;
        }
        accum.add(th);
        ExceptionHelper.flattenTraverse(th.getCause(), accum);
        for (Throwable suppressed : th.getSuppressed()) {
            ExceptionHelper.flattenTraverse(suppressed, accum);
        }
    }

    private void addMethod0(Map<Integer, Val> vars, String recvDesc, String methodName, ThrowingFunction2<CallContext, ExceptionVal, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s", recvDesc, methodName);
        FunVal fun = this.vm.fun.make(desc).action(c -> {
            HostResult hostResult;
            Val recv = c.recv();
            if (recv instanceof ExceptionVal) {
                ExceptionVal exc = (ExceptionVal)recv;
                hostResult = (HostResult)action.apply(c, exc);
            } else {
                hostResult = c.call(this.vm.graph.raiseFormat("{}: {} must be exception, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            return hostResult;
        });
        vars.put(this.vm.sym.handleFor(methodName), fun);
    }

    private void addBinaryOp(Map<Integer, Val> vars, String recvDesc, String methodName, String argDesc, ThrowingFunction3<CallContext, ExceptionVal, ExceptionVal, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s(%s)", recvDesc, methodName, argDesc);
        FunVal fun = this.vm.fun.make(desc).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof ExceptionVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be exception, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            ExceptionVal recvExc = (ExceptionVal)recv;
            Val arg = c.arg(0);
            if (!(arg instanceof ExceptionVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be exception, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.repr(arg)));
            }
            ExceptionVal argExc = (ExceptionVal)arg;
            return (HostResult)action.apply(c, recvExc, argExc);
        });
        vars.put(this.vm.sym.handleFor(methodName), fun);
    }

    private HostResult nextMethod(CallContext c, ExceptionVal recv) {
        return recv.next().map(next -> next).orElseGet(() -> c.call(this.vm.graph.raiseFormat("Exception.next: no next exception for {}", this.vm.graph.repr(recv))));
    }

    private HostResult raiseMethod(CallContext c, ExceptionVal recv) {
        return c.call(this.raiseDelegate(recv));
    }

    FunVal raiseDelegate(final ExceptionVal exc) {
        return new FunVal(this, this.vm){

            @Override
            void run(StackMachine stackMachine) {
                stackMachine.transitionToRaiseException(exc);
            }
        };
    }

    private HostResult descIterMethod(CallContext c, ExceptionVal recv) {
        return c.call("kink/EXCEPTION", this.descIterHandle).args((Val)recv);
    }

    private HostResult reprMethod(CallContext c, ExceptionVal recv) {
        GraphNode message = this.vm.graph.repr(this.vm.str.of(recv.message()));
        return c.call(recv.next().map(next -> this.vm.graph.format("(exception {} {})", message, this.vm.graph.repr((Val)next))).orElseGet(() -> this.vm.graph.format("(exception {})", message)));
    }

    private HostResult opEqMethod(CallContext c, ExceptionVal recv, ExceptionVal arg) {
        return this.vm.bool.of(recv.equals(arg));
    }

    private HostResult opAddMethod(CallContext c, ExceptionVal left, ExceptionVal right) {
        return left.chain(right);
    }
}

