/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.function.Function;
import org.kink_lang.kink.BindingVal;
import org.kink_lang.kink.CompileError;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.HostFunBuilderImpl;
import org.kink_lang.kink.LocationVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostFunBuilder;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.compile.ItreeCompiler;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.internal.program.ast.Parser;
import org.kink_lang.kink.internal.program.itree.NodeToItreeTranslator;
import org.kink_lang.kink.internal.program.itreeoptimize.ItreeOptimizers;
import org.kink_lang.kink.internal.program.lex.Lexer;

public class FunHelper {
    private final Vm vm;
    SharedVars sharedVars;
    private final HostFunBuilder defaultHostFunBuilder;

    FunHelper(Vm vm) {
        this.vm = vm;
        this.defaultHostFunBuilder = new HostFunBuilderImpl(vm, "(fun)", 0, OptionalInt.empty());
    }

    public <T> T compile(Locale locale, String programName, String programText, BindingVal binding, Function<? super FunVal, ? extends T> onSucc, Function<? super CompileError, ? extends T> onError) {
        Lexer lexer = new Lexer(locale);
        Parser parser = new Parser(locale);
        ItreeCompiler compiler = new ItreeCompiler(this.vm, MethodHandles.lookup(), programName, programText, binding);
        return (T)parser.parse(lexer.apply(programText), new NodeToItreeTranslator().andThen(ItreeOptimizers.getOptimizer()).andThen(compiler::compile).andThen(onSucc), (msg, fromPos, toPos) -> {
            LocationVal from = this.vm.location.of(programName, programText, (int)fromPos);
            LocationVal to = this.vm.location.of(programName, programText, (int)toPos);
            CompileError error = new CompileError((String)msg, from, to);
            return onError.apply(error);
        });
    }

    public HostFunBuilder make() {
        return this.defaultHostFunBuilder;
    }

    public HostFunBuilder make(String desc) {
        return new HostFunBuilderImpl(this.vm, desc, 0, OptionalInt.empty());
    }

    public FunVal constant(Val val) {
        return this.make("(constant)").take(0).action(c -> val);
    }

    void init() {
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        vars.put(this.vm.sym.handleFor("call"), this.vm.fun.make("Fun.call(Recv Args)").take(2).action(this::callMethod));
        vars.put(this.vm.sym.handleFor("repr"), this.method0("Fun.repr", (c, fun) -> this.vm.str.of(fun.getRepr())));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private FunVal method0(String prefix, ThrowingFunction2<CallContext, FunVal, HostResult> action) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun for Fun but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, (FunVal)recv);
        });
    }

    private HostResult callMethod(CallContext c) {
        Val val = c.recv();
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Fun.call(Recv Args): Fun must be fun, but got {}", this.vm.graph.repr(c.recv())));
        }
        FunVal fun = (FunVal)val;
        Val recv = c.arg(0);
        Val val2 = c.arg(1);
        if (!(val2 instanceof VecVal)) {
            return c.call(this.vm.graph.raiseFormat("Fun.call(Recv Args): Args must be vec, but got {}", this.vm.graph.repr(c.arg(1))));
        }
        VecVal args = (VecVal)val2;
        return c.call(fun).recv(recv).args((Val[])args.toList().toArray(Val[]::new));
    }
}

