/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.kink_lang.kink.DataStack;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.KontTagVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StackMachine;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.callstack.CallStack;
import org.kink_lang.kink.internal.callstack.CallStackSlice;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;

class KontTagHelper {
    private final Vm vm;
    Trace trace;
    SharedVars sharedVars;

    KontTagHelper(Vm vm) {
        this.vm = vm;
    }

    void init() {
        this.trace = Trace.of(this.vm.sym.handleFor("..kont tag.."));
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addMethod1(vars, "Kont_tag", "reset", "$thunk", this::resetMethod);
        this.addMethod1(vars, "Kont_tag", "shift", "$abort", this::shiftMethod);
        this.addMethod0(vars, "Kont_tag", "can_shift?", this::canShiftMethod);
        this.addMethod0(vars, "Kont_tag", "repr", this::reprMethod);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private void addMethod0(Map<Integer, Val> vars, String recvDesc, String name, ThrowingFunction3<CallContext, String, KontTagVal, HostResult> action) {
        int symHandle = this.vm.sym.handleFor(name);
        String desc = String.format(Locale.ROOT, "%s.%s)", recvDesc, name);
        vars.put(symHandle, this.vm.fun.make(desc).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof KontTagVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be kont_tag, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            KontTagVal kontTag = (KontTagVal)recv;
            return (HostResult)action.apply(c, desc, kontTag);
        }));
    }

    private void addMethod1(Map<Integer, Val> vars, String recvDesc, String name, String arg0Desc, ThrowingFunction4<CallContext, String, KontTagVal, Val, HostResult> action) {
        int symHandle = this.vm.sym.handleFor(name);
        String desc = String.format(Locale.ROOT, "%s.%s(%s)", recvDesc, name, arg0Desc);
        vars.put(symHandle, this.vm.fun.make(desc).take(1).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof KontTagVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be kont_tag, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            KontTagVal kontTag = (KontTagVal)recv;
            Val arg0 = c.arg(0);
            return (HostResult)action.apply(c, desc, kontTag, arg0);
        }));
    }

    private HostResult resetMethod(CallContext c, String desc, KontTagVal kontTag, Val arg) {
        if (!(arg instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $thunk must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(arg)));
        }
        FunVal thunk = (FunVal)arg;
        return c.call(this.resetDelegateFun(kontTag, thunk));
    }

    private FunVal resetDelegateFun(final KontTagVal kontTag, final FunVal thunk) {
        return new FunVal(this, this.vm){

            @Override
            void run(StackMachine stackMachine) {
                CallStack callStack = stackMachine.getCallStack();
                if (!callStack.isModerateSize()) {
                    stackMachine.transitionToRaise("call stack overflow");
                    return;
                }
                callStack.pushCse(kontTag, 0, 0, 0);
                DataStack dataStack = stackMachine.getDataStack();
                dataStack.removeFromOffset(0);
                dataStack.push(this.vm.nada);
                stackMachine.transitionToCall(thunk);
            }
        };
    }

    private HostResult shiftMethod(CallContext c, String desc, KontTagVal kontTag, Val arg) {
        if (!(arg instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $abort must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(arg)));
        }
        FunVal abort = (FunVal)arg;
        return c.call(this.shiftDelegateFun(desc, kontTag, abort));
    }

    private FunVal shiftDelegateFun(final String desc, final KontTagVal kontTag, final FunVal abort) {
        return new FunVal(this.vm){

            @Override
            void run(StackMachine stackMachine) {
                CallStack callStack = stackMachine.getCallStack();
                DataStack dataStack = stackMachine.getDataStack();
                if (!callStack.canAbort(kontTag)) {
                    FunVal fun = this.vm.fun.make().action(c -> c.call(this.vm.graph.raiseFormat("{}: {} not found on stack", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(kontTag))));
                    dataStack.removeFromOffset(0);
                    dataStack.push(this.vm.nada);
                    stackMachine.transitionToCall(fun);
                    return;
                }
                CallStackSlice callSlice = callStack.abort(kontTag);
                dataStack.removeFromOffset(0);
                int dataStackUsage = callSlice.dataStackUsage();
                Val[] dataSlice = stackMachine.getDataStack().sliceTop(dataStackUsage);
                dataStack.decreaseBp(dataStackUsage);
                dataStack.removeFromOffset(0);
                FunVal resumeFun = KontTagHelper.this.resumeFun(callSlice, dataSlice);
                dataStack.push(this.vm.nada);
                dataStack.push(resumeFun);
                stackMachine.transitionToCall(abort);
            }
        };
    }

    private FunVal resumeFun(CallStackSlice callSlice, Val[] dataSlice) {
        return this.vm.fun.make().take(1).action(c -> {
            Val arg = c.arg(0);
            return c.call(this.resumeDelegate(arg, callSlice, dataSlice));
        });
    }

    private FunVal resumeDelegate(final Val arg, final CallStackSlice callSlice, final Val[] dataSlice) {
        return new FunVal(this, this.vm){

            @Override
            void run(StackMachine stackMachine) {
                CallStack callStack = stackMachine.getCallStack();
                DataStack dataStack = stackMachine.getDataStack();
                dataStack.removeFromOffset(0);
                if (!callStack.canReplay(callSlice)) {
                    stackMachine.transitionToRaise("call stack overflow");
                    return;
                }
                if (!dataStack.ensureCapaSpPlus(dataSlice.length)) {
                    stackMachine.transitionToRaise("data stack overflow");
                    return;
                }
                dataStack.pushAll(dataSlice);
                dataStack.increaseBp(dataSlice.length);
                callStack.replay(callSlice);
                stackMachine.transitionToResult(arg);
            }
        };
    }

    private HostResult canShiftMethod(CallContext c, String desc, KontTagVal kontTag) {
        return c.call(this.canShiftDelegate(kontTag));
    }

    private FunVal canShiftDelegate(final KontTagVal kontTag) {
        return new FunVal(this, this.vm){

            @Override
            void run(StackMachine stackMachine) {
                CallStack callStack = stackMachine.getCallStack();
                stackMachine.transitionToResult(this.vm.bool.of(callStack.canAbort(kontTag)));
            }
        };
    }

    private HostResult reprMethod(CallContext c, String desc, KontTagVal kontTag) {
        return this.vm.str.of(String.format(Locale.ROOT, "(kont_tag val_id=%s)", kontTag.identity()));
    }
}

