/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.classgen;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.compile.classgen.BytecodeGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.JcirFactory;
import org.kink_lang.kink.internal.control.Control;

public class ClassGenerator {
    private static final System.Logger LOGGER = System.getLogger(ClassGenerator.class.getName());
    private final Vm vm;
    private final MethodHandles.Lookup packageLookup;

    public ClassGenerator(Vm vm, MethodHandles.Lookup packageLookup) {
        this.vm = vm;
        this.packageLookup = packageLookup;
    }

    public MethodHandles.Lookup generate(JavaClassIr jcir) throws Exception {
        LOGGER.log(System.Logger.Level.DEBUG, "generating class for {0}", jcir.desc());
        byte[] byteCode = new BytecodeGenerator().generate(jcir);
        MethodHandles.Lookup lookup = this.packageLookup.defineHiddenClass(byteCode, false, new MethodHandles.Lookup.ClassOption[0]);
        Class<?> klass = lookup.lookupClass();
        LOGGER.log(System.Logger.Level.DEBUG, "generated class for {0}: {1}", jcir.desc(), klass.getName());
        this.initTraceMap(lookup, klass, jcir.traces());
        this.initVmStatic(lookup, klass);
        this.initChildJcirFactories(lookup, klass, jcir.childJcirFactories());
        return lookup;
    }

    private void initTraceMap(MethodHandles.Lookup lookup, Class<? extends FunVal> klass, Map<Integer, Trace> traces) {
        Control.runWrappingThrowable(() -> {
            MethodHandle mh = lookup.findStaticSetter(klass, "traceMap", Map.class);
            mh.invoke(traces);
            return null;
        });
    }

    private void initVmStatic(MethodHandles.Lookup lookup, Class<? extends FunVal> klass) {
        Control.runWrappingThrowable(() -> {
            MethodHandle mh = lookup.findStaticSetter(klass, "vmStatic", Vm.class);
            mh.invoke(this.vm);
            return null;
        });
    }

    private void initChildJcirFactories(MethodHandles.Lookup lookup, Class<? extends FunVal> klass, List<JcirFactory> childJcirFactories) {
        Control.runWrappingThrowable(() -> {
            MethodHandle mh = lookup.findStaticSetter(klass, "childJcirFactories", List.class);
            mh.invoke(childJcirFactories);
            return null;
        });
    }
}

