/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kink_lang.kink.internal.compile.javaclassir.Allocation;
import org.kink_lang.kink.internal.function.Function4;
import org.kink_lang.kink.internal.intrinsicsupport.PreloadedFuns;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LocalVarContent;
import org.kink_lang.kink.internal.program.itree.UsedDefinedVars;

public record AllocationSet(Set<LocalVar> recv, Map<LocalVar, Integer> args, Set<LocalVar> control, List<LocalVar> field, List<LocalVar> stack) {
    private static final Set<LocalVar> CONTROL_LVARS = PreloadedFuns.controlSyms().stream().map(LocalVar.Original::new).collect(Collectors.toUnmodifiableSet());

    public Allocation get(LocalVar lvar) {
        if (this.recv().contains(lvar)) {
            return new Allocation.Recv();
        }
        if (this.args().containsKey(lvar)) {
            int argInd = this.args().get(lvar);
            return new Allocation.Arg(argInd);
        }
        if (this.control().contains(lvar)) {
            return new Allocation.Preloaded();
        }
        int fieldInd = this.field().indexOf(lvar);
        if (fieldInd >= 0) {
            return new Allocation.Field(fieldInd, this.isNonNull(lvar));
        }
        int stackInd = this.stack().indexOf(lvar);
        if (stackInd >= 0) {
            return new Allocation.Stack(stackInd, this.isNonNull(lvar));
        }
        return new Allocation.Unused();
    }

    private boolean isNonNull(LocalVar lvar) {
        return lvar instanceof LocalVar.Generated || CONTROL_LVARS.contains(lvar);
    }

    public static AllocationSet valCaptureControlOverridden(UsedDefinedVars vars) {
        return AllocationSet.valCapture(Set.of(), vars);
    }

    public static AllocationSet valCaptureControlUnchanged(UsedDefinedVars vars) {
        return AllocationSet.valCapture(CONTROL_LVARS, vars);
    }

    private static AllocationSet valCapture(Set<LocalVar> control, UsedDefinedVars vars) {
        return AllocationSet.analyze(control, vars, (recv, args, bound, free) -> {
            List<LocalVar> field = free.stream().sorted(Comparator.comparing(LocalVar::name)).toList();
            List<LocalVar> stack = bound.stream().sorted(Comparator.comparing(LocalVar::name)).toList();
            return new AllocationSet((Set<LocalVar>)recv, (Map<LocalVar, Integer>)args, control, field, stack);
        });
    }

    public static AllocationSet bindingCaptureControlOverridden(UsedDefinedVars vars) {
        return AllocationSet.bindingCapture(Set.of(), vars);
    }

    public static AllocationSet bindingCaptureControlUnchanged(UsedDefinedVars vars) {
        return AllocationSet.bindingCapture(CONTROL_LVARS, vars);
    }

    private static AllocationSet bindingCapture(Set<LocalVar> control, UsedDefinedVars vars) {
        return AllocationSet.analyze(control, vars, (recv, args, bound, free) -> {
            List<LocalVar> stack = Stream.concat(bound.stream(), free.stream()).sorted(Comparator.comparing(LocalVar::name)).toList();
            return new AllocationSet((Set<LocalVar>)recv, (Map<LocalVar, Integer>)args, control, List.of(), stack);
        });
    }

    private static AllocationSet analyze(Set<LocalVar> control, UsedDefinedVars vars, Function4<Set<LocalVar>, Map<LocalVar, Integer>, Set<LocalVar>, Set<LocalVar>, AllocationSet> emit) {
        HashSet<LocalVar> recv = new HashSet<LocalVar>();
        HashMap<LocalVar, Integer> args = new HashMap<LocalVar, Integer>();
        TreeSet<LocalVar> bound = new TreeSet<LocalVar>(Comparator.comparing(LocalVar::name));
        for (LocalVar lvar : vars.definedLvars()) {
            LocalVarContent content = vars.getContent(lvar);
            if (content instanceof LocalVarContent.Recv) {
                recv.add(lvar);
                continue;
            }
            if (content instanceof LocalVarContent.Arg) {
                LocalVarContent.Arg arg = (LocalVarContent.Arg)content;
                args.put(lvar, arg.index());
                continue;
            }
            if (!vars.isUsed(lvar)) continue;
            bound.add(lvar);
        }
        Set free = vars.freeLvars().stream().filter(Predicate.not(control::contains)).collect(Collectors.toUnmodifiableSet());
        return emit.apply(recv, args, bound, free);
    }
}

