/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.intrinsicsupport;

import java.util.Locale;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.vec.TraitError;

public class NewValSupport {
    private static final String DESC = "new_val(...[Sym1 Val1 Sym2 Val2 ,,,])";

    private NewValSupport() {
    }

    public static FunVal traitError(Vm vm, TraitError error, int arityDelta) {
        FunVal funVal;
        if (error instanceof TraitError.SymNotStr) {
            TraitError.SymNotStr symError = (TraitError.SymNotStr)error;
            funVal = NewValSupport.symNotStr(vm, symError.index(), symError.elem());
        } else {
            funVal = NewValSupport.oddNumbefOfArgs(vm, ((TraitError.ArityNotEven)error).arity() + arityDelta);
        }
        return funVal;
    }

    public static FunVal symNotStr(Vm vm, int index, Val val) {
        String paramName = "Sym" + (index / 2 + 1);
        String template = String.format(Locale.ROOT, "%s: %s must be str, but got {}", DESC, paramName);
        GraphNode raise = vm.graph.raiseFormat(template, vm.graph.repr(val));
        return vm.fun.make().action(c -> c.call(raise));
    }

    public static FunVal oddNumbefOfArgs(Vm vm, int argCount) {
        String message = String.format(Locale.ROOT, "%s: odd number of args: %d", DESC, argCount);
        return vm.fun.make().action(c -> c.raise(message));
    }
}

