/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.java;

import javax.annotation.Nullable;
import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.mod.java.JavaThrowVal;

public class JavaThrowMod {
    private final Vm vm;
    public static final String MOD_NAME = "kink/javahost/JAVA_THROW";

    private JavaThrowMod(Vm vm) {
        this.vm = vm;
    }

    public static Val makeMod(Vm vm) {
        return new JavaThrowMod(vm).makeMod();
    }

    private Val makeMod() {
        Val mod = this.vm.newVal();
        mod.setVar(this.vm.sym.handleFor("new"), this.vm.fun.make("JAVA_THROW.new(Exception_java_val)").take(1).action(this::newFun));
        mod.setVar(this.vm.sym.handleFor("is?"), this.vm.fun.make("JAVA_THROW.is?(Val)").take(1).action(this::isPFun));
        return mod;
    }

    private HostResult newFun(CallContext c) {
        Throwable th = this.extractThrowable(c.arg(0));
        if (th == null) {
            String desc = "JAVA_THROW.new(Exception_java_val)";
            return c.call(this.vm.graph.raiseFormat("{}: the arg must be a java val of a Throwable, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        return JavaThrowVal.of(this.vm, th);
    }

    @Nullable
    private Throwable extractThrowable(Val arg) {
        if (!(arg instanceof JavaVal)) {
            return null;
        }
        JavaVal excJavaVal = (JavaVal)arg;
        Object object = excJavaVal.objectReference();
        if (!(object instanceof Throwable)) {
            return null;
        }
        Throwable th = (Throwable)object;
        return th;
    }

    private HostResult isPFun(CallContext c) {
        return this.vm.bool.of(c.arg(0) instanceof JavaThrowVal);
    }
}

