/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.StrItree;
import org.kink_lang.kink.internal.program.itree.SymValPair;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;

public class SimpleNewValInliner
extends BaseOptimizer {
    @Override
    public Itree visit(SymcallItree scall) {
        if (!scall.isLocalCallOf("new_val")) {
            return scall;
        }
        List<ItreeElem> argElems = scall.args();
        if (!argElems.stream().allMatch(ItreeElem::isSingle)) {
            return scall;
        }
        List<Itree> args = argElems.stream().map(ItreeElem::expr).toList();
        if (args.size() % 2 != 0) {
            return scall;
        }
        ArrayList<SymValPair> symValPairs = new ArrayList<SymValPair>();
        for (int i = 0; i < args.size(); i += 2) {
            Itree symItree = args.get(i);
            if (!(symItree instanceof StrItree)) {
                return scall;
            }
            StrItree sym = (StrItree)symItree;
            Itree val = args.get(i + 1);
            symValPairs.add(new SymValPair(sym.str(), val));
        }
        return new NoTraitNewValItree(symValPairs, scall.pos());
    }
}

