/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize.ssafy;

import java.util.HashSet;
import java.util.Set;
import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.BiArithmeticItree;
import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.DeepTransformer;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.McallItree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;

public class SsaChecker
implements DeepTransformer.Callback {
    private final Set<LocalVar> captured = new HashSet<LocalVar>();
    private boolean hasBeenInvoked = false;

    public static boolean canConvertToSsa(Itree body) {
        try {
            DeepTransformer.deepTransform(body, new SsaChecker());
            return true;
        }
        catch (CannotSsafyException ex) {
            return false;
        }
    }

    private void capture(Set<LocalVar> capturedLvars) {
        this.captured.addAll(capturedLvars);
    }

    private void invocation() {
        this.hasBeenInvoked = true;
    }

    @Override
    public LocalVar derefLvar(LocalVar lvar) {
        return lvar;
    }

    @Override
    public LocalVar storeLvar(LocalVar lvar) {
        if (this.hasBeenInvoked || this.captured.contains(lvar)) {
            throw new CannotSsafyException();
        }
        return lvar;
    }

    @Override
    public Itree itree(Itree itree) {
        itree.accept(new Visitor());
        return itree;
    }

    public static class CannotSsafyException
    extends RuntimeException {
        private static final long serialVersionUID = -5283922630086248066L;
    }

    private class Visitor
    extends SkeltonItreeVisitor<Void> {
        Visitor() {
            super((Itree itree) -> null);
        }

        @Override
        public Void visit(BindingItree itree) {
            throw new CannotSsafyException();
        }

        @Override
        public Void visit(SlowFunItree itree) {
            throw new CannotSsafyException();
        }

        @Override
        public Void visit(FastFunItree itree) {
            SsaChecker.this.capture(itree.freeLvars());
            return null;
        }

        @Override
        public Void visit(AssignmentItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(BiArithmeticItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(NoTraitNewValItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(TraitNewValItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(IfItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(BranchItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(BranchWithElseItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(McallItree itree) {
            SsaChecker.this.invocation();
            return null;
        }

        @Override
        public Void visit(SymcallItree itree) {
            SsaChecker.this.invocation();
            return null;
        }
    }
}

