package org.kink_lang.kink;

/**
 * Factory of funs of kink/KONT_TAG mod.
 */
class KontTagMod {

    /** The vm. */
    private final Vm vm;

    /**
     * Constructs the factory.
     */
    KontTagMod(Vm vm) {
        this.vm = vm;
    }

    /**
     * Makes kink/KONT_TAG mod.
     */
    Val makeMod() {
        Val mod = vm.newVal();
        mod.setVar(vm.sym.handleFor("new"),
                vm.fun.make("KONT_TAG.new").take(0)
                .action(c -> new KontTagVal(vm)));
        mod.setVar(vm.sym.handleFor("is?"),
                vm.fun.make("KONT_TAG.is?(Val)").take(1)
                .action(c -> vm.bool.of(c.arg(0) instanceof KontTagVal)));
        mod.setVar(vm.sym.handleFor("escape_tag"), vm.fun.constant(vm.escapeKontTag));
        return mod;
    }

}

// vim: et sw=4 sts=4 fdm=marker
